/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension.font;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import java.awt.Color;

public abstract class AbstractFontRegistry {
    private static boolean registerFontDirectories = false;

    public Font getFont(String familyName, float size, int style, Color color) {
        this.registerFontDirectoriesIfNeeded();
        if (familyName != null) {
            familyName = this.resolveFamilyName(familyName, style);
        }
        return FontFactory.getFont((String)familyName, (float)size, (int)style, (Color)color);
    }

    private void registerFontDirectoriesIfNeeded() {
        if (!registerFontDirectories) {
            FontFactory.registerDirectories();
            registerFontDirectories = true;
        }
    }

    public boolean isBold(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 1) == 1;
    }

    public boolean isItalic(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 2) == 2;
    }

    public boolean isUnderlined(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 4) == 4;
    }

    public boolean isStrikethru(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 8) == 8;
    }

    protected abstract String resolveFamilyName(String var1, int var2);
}

