/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.docx.poi.xhtml;

import fr.opensagres.xdocreport.converter.IURIResolver;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.OptionsHelper;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.docx.poi.itext.XWPF2PDFViaITextConverter;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterNoEntriesSupport;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.poi.xwpf.converter.xhtml.XHTMLConverter;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class XWPF2XHTMLConverter
extends AbstractConverterNoEntriesSupport
implements MimeMappingConstants {
    private static final XWPF2XHTMLConverter INSTANCE = new XWPF2XHTMLConverter();
    private static final Logger LOGGER = LogUtils.getLogger((String)XWPF2PDFViaITextConverter.class.getName());

    public static XWPF2XHTMLConverter getInstance() {
        return INSTANCE;
    }

    public void convert(InputStream in, OutputStream out, Options options) throws XDocConverterException {
        try {
            XWPFDocument document = new XWPFDocument(in);
            XHTMLConverter.getInstance().convert(document, out, (org.apache.poi.xwpf.converter.core.Options)this.toXHTMLOptions(options));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new XDocConverterException((Throwable)e);
        }
    }

    public XHTMLOptions toXHTMLOptions(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(XHTMLOptions.class);
        if (value instanceof XHTMLOptions) {
            return (XHTMLOptions)value;
        }
        XHTMLOptions xhtmlOptions = XHTMLOptions.create();
        final IURIResolver resolver = OptionsHelper.getURIResolver((Options)options);
        if (resolver != null) {
            xhtmlOptions.URIResolver(new org.apache.poi.xwpf.converter.core.IURIResolver(){

                public String resolve(String uri) {
                    return resolver.resolve(uri);
                }
            });
        }
        return xhtmlOptions;
    }

    public MimeMapping getMimeMapping() {
        return XHTML_MIME_MAPPING;
    }

    public boolean isDefault() {
        return true;
    }
}

