/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.odt.odfdom.itext;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.OptionsHelper;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterNoEntriesSupport;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.odftoolkit.odfdom.converter.core.ODFConverterException;
import org.odftoolkit.odfdom.converter.pdf.PdfConverter;
import org.odftoolkit.odfdom.converter.pdf.PdfOptions;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;

public class ODF2PDFViaITextConverter
extends AbstractConverterNoEntriesSupport
implements MimeMappingConstants {
    private static final ODF2PDFViaITextConverter INSTANCE = new ODF2PDFViaITextConverter();

    public static ODF2PDFViaITextConverter getInstance() {
        return INSTANCE;
    }

    public void convert(InputStream in, OutputStream out, Options options) throws XDocConverterException {
        try {
            OdfTextDocument odfDocument = OdfTextDocument.loadDocument((InputStream)in);
            PdfConverter.getInstance().convert((OdfDocument)odfDocument, out, (org.odftoolkit.odfdom.converter.core.Options)this.toPdfOptions(options));
        }
        catch (ODFConverterException e) {
            throw new XDocConverterException((Throwable)e);
        }
        catch (IOException e) {
            throw new XDocConverterException((Throwable)e);
        }
        catch (Exception e) {
            throw new XDocConverterException((Throwable)e);
        }
    }

    public PdfOptions toPdfOptions(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(PdfOptions.class);
        if (value instanceof PdfOptions) {
            return (PdfOptions)value;
        }
        PdfOptions pdfOptions = PdfOptions.create();
        String fontEncoding = OptionsHelper.getFontEncoding((Options)options);
        if (StringUtils.isNotEmpty((String)fontEncoding)) {
            pdfOptions.fontEncoding(fontEncoding);
        }
        return pdfOptions;
    }

    public MimeMapping getMimeMapping() {
        return PDF_MIME_MAPPING;
    }

    public boolean isDefault() {
        return true;
    }
}

