/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.DocXConstants;
import fr.opensagres.xdocreport.document.docx.DocxUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.BookmarkBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.DocxBufferedDocument;
import fr.opensagres.xdocreport.document.docx.preprocessor.FldSimpleBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.MergefieldBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.RBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocXBufferedDocumentContentHandler
extends TransformedBufferedDocumentContentHandler<DocxBufferedDocument>
implements DocXConstants {
    private boolean instrTextParsing;
    private boolean tParsing = false;

    protected DocXBufferedDocumentContentHandler(FieldsMetadata fieldsMetadata, IDocumentFormatter formater, Map<String, Object> context) {
        super(fieldsMetadata, formater, context);
    }

    protected DocxBufferedDocument createDocument() {
        return new DocxBufferedDocument(this);
    }

    protected String getTableRowName() {
        return "w:tr";
    }

    protected String getTableCellName() {
        return "w:tc";
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String newEmbed;
        BookmarkBufferedRegion currentBookmark;
        IDocumentFormatter formatter = super.getFormatter();
        RBufferedRegion currentRRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentRRegion();
        if (DocxUtils.isFldChar(uri, localName, name) && currentRRegion != null) {
            String fldCharType = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldCharType");
            currentRRegion.setFldCharType(fldCharType);
            return super.doStartElement(uri, localName, name, attributes);
        }
        if (DocxUtils.isInstrText(uri, localName, name) && currentRRegion != null) {
            this.instrTextParsing = true;
            return super.doStartElement(uri, localName, name, attributes);
        }
        if (DocxUtils.isT(uri, localName, name)) {
            this.tParsing = true;
            return super.doStartElement(uri, localName, name, attributes);
        }
        if (DocxUtils.isFldSimple(uri, localName, name)) {
            FldSimpleBufferedRegion currentFldSimpleRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentFldSimpleRegion();
            if (currentFldSimpleRegion.getFieldName() == null) {
                super.doStartElement(uri, localName, name, attributes);
                return true;
            }
            return false;
        }
        if (DocxUtils.isBlip(uri, localName, name) && (currentBookmark = ((DocxBufferedDocument)this.bufferedDocument).getCurrentBookmark()) != null && formatter != null && StringUtils.isNotEmpty((String)(newEmbed = formatter.getImageDirective(this.processRowIfNeeded(currentBookmark.getImageFieldName(), true))))) {
            AttributesImpl attr = DocXBufferedDocumentContentHandler.toAttributesImpl((Attributes)attributes);
            int index = attr.getIndex("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "embed");
            attr.setValue(index, newEmbed);
            attributes = attr;
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        BufferedElement currentRegion = this.getCurrentElement();
        RBufferedRegion currentRRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentRRegion();
        if (DocxUtils.isInstrText(uri, localName, name) && currentRRegion != null) {
            super.doEndElement(uri, localName, name);
            this.instrTextParsing = false;
            return;
        }
        if (DocxUtils.isT(uri, localName, name)) {
            super.doEndElement(uri, localName, name);
            this.tParsing = false;
            return;
        }
        FldSimpleBufferedRegion currentFldSimpleRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentFldSimpleRegion();
        if (DocxUtils.isFldSimple(uri, localName, name) && currentFldSimpleRegion != null) {
            String fieldName = currentFldSimpleRegion.getFieldName();
            if (fieldName == null) {
                super.doEndElement(uri, localName, name);
            }
            return;
        }
        super.doEndElement(uri, localName, name);
    }

    protected void flushCharacters(String characters) {
        FldSimpleBufferedRegion currentFldSimpleRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentFldSimpleRegion();
        if (this.tParsing && currentFldSimpleRegion != null) {
            currentFldSimpleRegion.setTContent(characters);
            this.extractListDirectiveInfo(currentFldSimpleRegion);
            this.resetCharacters();
            return;
        }
        RBufferedRegion currentRRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentRRegion();
        if (currentRRegion != null) {
            if (this.instrTextParsing) {
                characters = this.processRowIfNeeded(characters);
                currentRRegion.setInstrText(characters);
                this.extractListDirectiveInfo(currentRRegion);
                this.resetCharacters();
                return;
            }
            if (this.tParsing) {
                currentRRegion.setTContent(characters);
                this.resetCharacters();
                return;
            }
        }
        super.flushCharacters(characters);
    }

    private void extractListDirectiveInfo(MergefieldBufferedRegion mergefield) {
        super.extractListDirectiveInfo(mergefield.getFieldName());
    }
}

