/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor;

import fr.opensagres.xdocreport.core.utils.XMLUtils;
import fr.opensagres.xdocreport.document.docx.DocXConstants;
import fr.opensagres.xdocreport.document.docx.DocxUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.BookmarkBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.DocXBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.FldSimpleBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.PBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.RBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocument;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocxBufferedDocument
extends TransformedBufferedDocument
implements DocXConstants {
    private final DocXBufferedDocumentContentHandler handler;
    private PBufferedRegion currentPRegion;
    private FldSimpleBufferedRegion currentFldSimpleRegion;
    private RBufferedRegion currentRRegion;
    private BookmarkBufferedRegion currentBookmark;
    private HyperlinkBufferedRegion currentHyperlink;

    public DocxBufferedDocument(DocXBufferedDocumentContentHandler handler) {
        this.handler = handler;
    }

    protected BufferedElement createElement(BufferedElement parent, String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (DocxUtils.isFldChar(uri, localName, name) && this.currentRRegion != null) {
            String fldCharType = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldCharType");
            this.currentRRegion.setFldCharType(fldCharType);
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isP(uri, localName, name)) {
            this.currentPRegion = new PBufferedRegion(this.getCurrentElement(), uri, localName, name, attributes);
            return this.currentPRegion;
        }
        if (DocxUtils.isR(uri, localName, name) && this.currentFldSimpleRegion == null) {
            this.currentRRegion = new RBufferedRegion(this.handler, parent, uri, localName, name, attributes);
            HyperlinkBufferedRegion hyperlink = this.getCurrentHyperlink();
            if (hyperlink != null) {
                hyperlink.addRegion((ISavable)this.currentRRegion);
            } else {
                PBufferedRegion pRegion = this.getCurrentPRegion();
                if (pRegion != null) {
                    pRegion.addRegion((ISavable)this.currentRRegion);
                }
            }
            return this.currentRRegion;
        }
        if (DocxUtils.isFldSimple(uri, localName, name)) {
            String instrText = this.handler.processRowIfNeeded(attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "instr"));
            this.currentFldSimpleRegion = new FldSimpleBufferedRegion(this.handler, parent, uri, localName, name, attributes);
            this.currentFldSimpleRegion.setInstrText(instrText);
            if (this.currentFldSimpleRegion.getFieldName() == null) {
                // empty if block
            }
            return this.currentFldSimpleRegion;
        }
        if (DocxUtils.isBookmarkStart(uri, localName, name)) {
            String imageFieldName;
            String bookmarkName = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "name");
            FieldsMetadata fieldsMetadata = this.handler.getFieldsMetadata();
            if (fieldsMetadata != null && (imageFieldName = fieldsMetadata.getImageFieldName(bookmarkName)) != null) {
                this.currentBookmark = new BookmarkBufferedRegion(bookmarkName, imageFieldName, parent, uri, localName, imageFieldName, attributes);
                return this.currentBookmark;
            }
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isBookmarkEnd(uri, localName, name)) {
            this.currentBookmark = null;
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isHyperlink(uri, localName, name)) {
            int idIndex = attributes.getIndex("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id");
            if (idIndex != -1) {
                String attrName = attributes.getQName(idIndex);
                AttributesImpl attributesImpl = XMLUtils.toAttributesImpl((Attributes)attributes);
                attributesImpl.removeAttribute(idIndex);
                String id = attributes.getValue(idIndex);
                this.currentHyperlink = new HyperlinkBufferedRegion(this.handler, parent, uri, localName, name, attributesImpl);
                this.currentHyperlink.setId(attrName, id);
                return this.currentHyperlink;
            }
            return super.createElement(parent, uri, localName, name, attributes);
        }
        return super.createElement(parent, uri, localName, name, attributes);
    }

    public BookmarkBufferedRegion getCurrentBookmark() {
        return this.currentBookmark;
    }

    public FldSimpleBufferedRegion getCurrentFldSimpleRegion() {
        return this.currentFldSimpleRegion;
    }

    public HyperlinkBufferedRegion getCurrentHyperlink() {
        return this.currentHyperlink;
    }

    public PBufferedRegion getCurrentPRegion() {
        return this.currentPRegion;
    }

    public RBufferedRegion getCurrentRRegion() {
        return this.currentRRegion;
    }

    public void onEndEndElement(String uri, String localName, String name) {
        if (DocxUtils.isP(uri, localName, name) && this.currentPRegion != null) {
            super.onEndEndElement(uri, localName, name);
            this.currentPRegion.process();
            this.currentPRegion = null;
            return;
        }
        if (DocxUtils.isR(uri, localName, name) && this.currentRRegion != null && this.currentFldSimpleRegion == null) {
            super.onEndEndElement(uri, localName, name);
            this.currentRRegion = null;
            return;
        }
        if (DocxUtils.isFldSimple(uri, localName, name) && this.currentFldSimpleRegion != null) {
            String fieldName = this.currentFldSimpleRegion.getFieldName();
            if (fieldName != null) {
                boolean hasScript = this.handler.processScriptBefore(fieldName);
                if (!hasScript) {
                    hasScript = this.handler.processScriptAfter(fieldName);
                }
                if (hasScript) {
                    this.currentFldSimpleRegion.reset();
                }
            }
            super.onEndEndElement(uri, localName, name);
            this.currentFldSimpleRegion = null;
            return;
        }
        if (DocxUtils.isHyperlink(uri, localName, name)) {
            HyperlinkBufferedRegion hyperlink = this.currentHyperlink;
            super.onEndEndElement(uri, localName, name);
            hyperlink.process();
            return;
        }
        super.onEndEndElement(uri, localName, name);
    }

    protected boolean isTable(String uri, String localName, String name) {
        return DocxUtils.isTable(uri, localName, name);
    }

    protected boolean isTableRow(String uri, String localName, String name) {
        return DocxUtils.isTableRow(uri, localName, name);
    }
}

