/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor;

import fr.opensagres.xdocreport.core.EncodingConstants;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.Attributes;

public abstract class MergefieldBufferedRegion
extends BufferedElement
implements EncodingConstants {
    private static final String MERGEFORMAT = "\\* MERGEFORMAT";
    private static final String MERGEFIELD_FIELD_TYPE = "MERGEFIELD";
    private static final String HYPERLINK_FIELD_TYPE = "HYPERLINK";
    private final TransformedBufferedDocumentContentHandler handler;
    private String fieldName;
    private BufferedElement tRegion;

    public MergefieldBufferedRegion(TransformedBufferedDocumentContentHandler handler, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.handler = handler;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String setInstrText(String instrText) {
        this.fieldName = MergefieldBufferedRegion.getFieldName(instrText);
        if (this.fieldName == null) {
            return this.decodeInstrTextIfNeeded(instrText);
        }
        return instrText;
    }

    private String decodeInstrTextIfNeeded(String instrText) {
        String fieldName;
        IDocumentFormatter formatter = this.handler.getFormatter();
        if (formatter == null) {
            return instrText;
        }
        int index = instrText.indexOf(HYPERLINK_FIELD_TYPE);
        if (index != -1 && StringUtils.isNotEmpty((String)(fieldName = instrText.substring(index + HYPERLINK_FIELD_TYPE.length(), instrText.length()).trim()))) {
            if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            if (formatter.containsInterpolation(fieldName = StringUtils.decode((String)fieldName))) {
                return StringUtils.decode((String)instrText);
            }
        }
        return instrText;
    }

    public static String getFieldName(String instrText) {
        String fieldName;
        if (StringUtils.isEmpty((String)instrText)) {
            return null;
        }
        int index = instrText.indexOf(MERGEFIELD_FIELD_TYPE);
        if (index != -1 && StringUtils.isNotEmpty((String)(fieldName = instrText.substring(index + MERGEFIELD_FIELD_TYPE.length(), instrText.length()).trim()))) {
            if (fieldName.endsWith(MERGEFORMAT)) {
                fieldName = fieldName.substring(0, fieldName.length() - MERGEFORMAT.length()).trim();
            }
            if (StringUtils.isNotEmpty((String)fieldName)) {
                if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                    fieldName = fieldName.substring(1, fieldName.length() - 1);
                }
                fieldName = StringUtils.replaceAll((String)fieldName, (String)"\\\"", (String)"\"");
                fieldName = StringUtils.replaceAll((String)fieldName, (String)"&apos;", (String)"'");
                return fieldName;
            }
        }
        return null;
    }

    public BufferedElement getTRegion() {
        if (this.tRegion == null) {
            this.tRegion = super.findFirstChild("w:t");
        }
        return this.tRegion;
    }
}

