/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor;

import fr.opensagres.xdocreport.document.docx.DocXConstants;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkInfo;
import fr.opensagres.xdocreport.document.docx.preprocessor.InitialHyperlinkMap;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Collection;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocxDocumentXMLRelsDocumentContentHandler
extends BufferedDocumentContentHandler
implements DocXConstants {
    private static final String ITEM_INFO = "___info";
    protected final IDocumentFormatter formatter;
    protected final FieldsMetadata fieldsMetadata;
    private final Map<String, HyperlinkInfo> hyperlinksMap;
    private boolean hyperlinkParsing = false;

    public DocxDocumentXMLRelsDocumentContentHandler(FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        this.formatter = formatter;
        this.fieldsMetadata = fieldsMetadata;
        this.hyperlinksMap = sharedContext == null ? null : (InitialHyperlinkMap)sharedContext.get("___Hyperlinks");
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String type;
        if ("Relationship".equals(name) && "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(type = attributes.getValue("Type")) && this.hyperlinksMap != null) {
            this.hyperlinkParsing = true;
            return false;
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (this.hyperlinkParsing) {
            this.hyperlinkParsing = false;
            return;
        }
        if ("Relationships".equals(name)) {
            StringBuilder script = new StringBuilder();
            this.generateScriptsForDynamicImages(script);
            this.generateScriptsForStaticHyperlinks(script);
            this.generateScriptsForDynamicHyperlinks(script);
            BufferedElement currentRegion = this.getCurrentElement();
            currentRegion.append(script.toString());
        }
        super.doEndElement(uri, localName, name);
    }

    private void generateScriptsForDynamicImages(StringBuilder script) {
        String startIf = this.formatter.getStartIfDirective("imageRegistry");
        script.append(startIf);
        String listInfos = this.formatter.formatAsSimpleField(false, new String[]{"imageRegistry", "ImageProviderInfos"});
        String itemListInfos = this.formatter.formatAsSimpleField(false, new String[]{ITEM_INFO});
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String relationId = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "ImageId"});
        String target = "media/" + this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "ImageFileName"});
        this.generateRelationship(script, relationId, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", target, null);
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
        script.append(this.formatter.getEndIfDirective("imageRegistry"));
    }

    private void generateScriptsForStaticHyperlinks(StringBuilder script) {
        if (this.hyperlinksMap != null) {
            Collection<HyperlinkInfo> hyperlinks = this.hyperlinksMap.values();
            for (HyperlinkInfo hyperlink : hyperlinks) {
                this.generateRelationship(script, hyperlink.getId(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink", hyperlink.getTarget(), hyperlink.getTargetMode());
            }
        }
    }

    private void generateScriptsForDynamicHyperlinks(StringBuilder script) {
        String startIf = this.formatter.getStartIfDirective("___HyperlinkRegistry");
        script.append(startIf);
        String listInfos = this.formatter.formatAsSimpleField(false, new String[]{"___HyperlinkRegistry", "Hyperlinks"});
        String itemListInfos = this.formatter.formatAsSimpleField(false, new String[]{ITEM_INFO});
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String relationId = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "Id"});
        String target = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "Target"});
        String targetMode = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "TargetMode"});
        this.generateRelationship(script, relationId, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink", target, targetMode);
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
        script.append(this.formatter.getEndIfDirective("___HyperlinkRegistry"));
    }

    protected void generateRelationship(StringBuilder script, String relationId, String type, String target, String targetMode) {
        script.append("<");
        script.append("Relationship");
        script.append(" ");
        script.append("Id");
        script.append("=\"");
        script.append(relationId);
        script.append("\" ");
        script.append("Type");
        script.append("=\"");
        script.append(type);
        script.append("\" ");
        script.append("Target");
        script.append("=\"");
        script.append(target);
        if (targetMode != null) {
            script.append("\" ");
            script.append("TargetMode");
            script.append("=\"");
            script.append(targetMode);
        }
        script.append("\" />");
    }
}

