/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.textstyling;

import fr.opensagres.xdocreport.template.textstyling.AbstractDocumentHandler;
import java.util.Stack;

public class DocxDocumentHandler
extends AbstractDocumentHandler {
    private boolean bolding;
    private boolean italicsing;
    private Stack<Boolean> paragraphsStack;

    public void startDocument() {
        this.bolding = false;
        this.italicsing = false;
        this.paragraphsStack = new Stack();
    }

    public void endDocument() {
        if (!this.paragraphsStack.isEmpty()) {
            this.paragraphsStack.size();
            for (int i = 0; i < this.paragraphsStack.size(); ++i) {
                this.internalEndParagraph();
            }
        }
    }

    public void startBold() {
        this.bolding = true;
    }

    public void endBold() {
        this.bolding = false;
    }

    public void startItalics() {
        this.italicsing = true;
    }

    public void endItalics() {
        this.italicsing = false;
    }

    public void handleString(String content) {
        this.writer.write("<w:r>");
        if (this.bolding || this.italicsing) {
            this.writer.write("<w:rPr>");
            if (this.bolding) {
                this.writer.write("<w:b />");
            }
            if (this.italicsing) {
                this.writer.write("<w:i />");
            }
            this.writer.write("</w:rPr>");
        }
        this.writer.write("<w:t xml:space=\"preserve\" >");
        this.writer.write(content);
        this.writer.write("</w:t>");
        this.writer.write("</w:r>");
    }

    private void startParagraphIfNeeded() {
        if (this.paragraphsStack.isEmpty()) {
            this.internalStartParagraph(false);
        }
    }

    private void internalStartParagraph(boolean containerIsList) {
        this.writer.write("<w:p>");
        this.paragraphsStack.push(containerIsList);
    }

    private void internalEndParagraph() {
        this.writer.write("</w:p>");
        this.paragraphsStack.pop();
    }

    public void startListItem() {
        this.internalStartParagraph(true);
        boolean ordered = super.getCurrentListOrder();
        this.writer.write("<w:pPr>");
        this.writer.write("<w:pStyle w:val=\"Paragraphedeliste\" />");
        this.writer.write("<w:numPr>");
        int ilvlVal = super.getCurrentListIndex();
        this.writer.write("<w:ilvl w:val=\"");
        this.writer.write(String.valueOf(ilvlVal));
        this.writer.write("\" />");
        int numIdVal = ordered ? 2 : 1;
        this.writer.write("<w:numId w:val=\"");
        this.writer.write(String.valueOf(numIdVal));
        this.writer.write("\" />");
        this.writer.write("</w:numPr>");
        this.writer.write("</w:pPr>");
    }

    public void endListItem() {
        this.internalEndParagraph();
    }

    public void startParagraph() {
        this.internalStartParagraph(false);
    }

    public void endParagraph() {
        this.internalEndParagraph();
    }
}

