/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.docx.DocXConstants;
import fr.opensagres.xdocreport.document.docx.images.DocxImageRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.DocXPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.DocxContentTypesPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.DocxDocumentXMLRelsPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.InitialHyperlinkMap;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocXReport
extends AbstractXDocReport
implements DocXConstants {
    private static final long serialVersionUID = -2323716817951928168L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"word/document.xml", "word/styles.xml", "word/header*.xml", "word/footer*.xml", "word/_rels/document.xml.rels"};
    static final String WORD_REGEXP = "word*";
    private boolean hasDynamicHyperlinks = false;

    public String getKind() {
        return DocumentKind.DOCX.name();
    }

    protected void registerPreprocessors() {
        super.addPreprocessor("word/document.xml", DocXPreprocessor.INSTANCE);
        super.addPreprocessor("word/header*.xml", DocXPreprocessor.INSTANCE);
        super.addPreprocessor("word/footer*.xml", DocXPreprocessor.INSTANCE);
        super.addPreprocessor("[Content_Types].xml", DocxContentTypesPreprocessor.INSTANCE);
        super.addPreprocessor("word/_rels/document.xml.rels", DocxDocumentXMLRelsPreprocessor.INSTANCE);
    }

    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    public MimeMapping getMimeMapping() {
        return MIME_MAPPING;
    }

    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new DocxImageRegistry(readerProvider, writerProvider, outputStreamProvider);
    }

    protected void onBeforePreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onBeforePreprocessing(sharedContext, preprocessedArchive);
        HyperlinkContentHandler contentHandler = new HyperlinkContentHandler();
        Reader reader = preprocessedArchive.getEntryReader("word/_rels/document.xml.rels");
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(reader));
            if (contentHandler.getHyperlinks() != null) {
                sharedContext.put("___Hyperlinks", contentHandler.getHyperlinks());
            }
        }
        catch (SAXException e) {
            throw new XDocReportException((Throwable)e);
        }
        catch (IOException e) {
            throw new XDocReportException((Throwable)e);
        }
    }

    protected void onAfterPreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onAfterPreprocessing(sharedContext, preprocessedArchive);
        if (sharedContext != null) {
            InitialHyperlinkMap hyperlinkMap = (InitialHyperlinkMap)sharedContext.get("___Hyperlinks");
            this.hasDynamicHyperlinks = hyperlinkMap == null ? false : hyperlinkMap.isModified();
        }
    }

    protected void onBeforeProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onBeforeProcessTemplateEngine(context, outputArchive);
        if (this.hasDynamicHyperlinks) {
            context.put("___HyperlinkRegistry", (Object)new HyperlinkRegistry());
        }
    }

    protected void onAfterProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onAfterProcessTemplateEngine(context, outputArchive);
    }
}

