/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx;

import fr.opensagres.xdocreport.core.io.XDocArchive;

public class DocxUtils {
    public static boolean isDocx(XDocArchive documentArchive) {
        if (!documentArchive.hasEntry("[Content_Types].xml")) {
            return false;
        }
        return documentArchive.getEntryNames("word*").size() > 0;
    }

    public static boolean isTable(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "tbl".equals(localName);
    }

    public static boolean isTableRow(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "tr".equals(localName);
    }

    public static boolean isFldSimple(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "fldSimple".equals(localName);
    }

    public static boolean isP(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "p".equals(localName);
    }

    public static boolean isR(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "r".equals(localName);
    }

    public static boolean isT(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "t".equals(localName);
    }

    public static boolean isFldChar(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "fldChar".equals(localName);
    }

    public static boolean isInstrText(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "instrText".equals(localName);
    }

    public static boolean isBookmarkStart(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "bookmarkStart".equals(localName);
    }

    public static boolean isBookmarkEnd(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "bookmarkEnd".equals(localName);
    }

    public static boolean isBlip(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/drawingml/2006/main".equals(uri) && "blip".equals(localName);
    }

    public static boolean isExtent(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing".equals(uri) && "extent".equals(localName);
    }

    public static boolean isExt(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/drawingml/2006/main".equals(uri) && "ext".equals(localName);
    }

    public static boolean isHyperlink(String uri, String localName, String name) {
        return "http://schemas.openxmlformats.org/wordprocessingml/2006/main".equals(uri) && "hyperlink".equals(localName);
    }
}

