/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocxContentTypesDocumentContentHandler
extends BufferedDocumentContentHandler {
    private List<ImageFormat> missingFormats = new ArrayList<ImageFormat>();

    public void startDocument() throws SAXException {
        ImageFormat format = null;
        ImageFormat[] formats = ImageFormat.values();
        for (int i = 0; i < formats.length; ++i) {
            format = formats[i];
            this.missingFormats.add(format);
        }
        super.startDocument();
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        ImageFormat format;
        if ("Default".equals(name) && (format = ImageFormat.getFormatByExtension((String)attributes.getValue("Extension"))) != null) {
            this.missingFormats.remove(format);
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if ("Types".equals(name)) {
            for (ImageFormat format : this.missingFormats) {
                BufferedElement currentRegion = this.getCurrentElement();
                currentRegion.append("<Default Extension=\"");
                currentRegion.append(format.name());
                currentRegion.append("\" ContentType=\"image/");
                currentRegion.append(format.getType());
                currentRegion.append("\" />");
            }
        }
        super.doEndElement(uri, localName, name);
    }
}

