/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.textstyling;

import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.textstyling.AbstractDocumentHandler;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.util.Stack;

public class DocxDocumentHandler
extends AbstractDocumentHandler {
    private boolean bolding;
    private boolean italicsing;
    private Stack<Boolean> paragraphsStack;
    private HyperlinkRegistry hyperlinkRegistry;

    public DocxDocumentHandler(BufferedElement parent, IContext context, String entryName) {
        super(parent, context, entryName);
    }

    public void startDocument() {
        this.bolding = false;
        this.italicsing = false;
        this.paragraphsStack = new Stack();
    }

    public void endDocument() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            this.paragraphsStack.size();
            for (int i = 0; i < this.paragraphsStack.size(); ++i) {
                this.internalEndParagraph();
            }
        }
    }

    public void startBold() {
        this.bolding = true;
    }

    public void endBold() {
        this.bolding = false;
    }

    public void startItalics() {
        this.italicsing = true;
    }

    public void endItalics() {
        this.italicsing = false;
    }

    public void handleString(String content) throws IOException {
        super.write("<w:r>");
        if (this.bolding || this.italicsing) {
            super.write("<w:rPr>");
            if (this.bolding) {
                super.write("<w:b />");
            }
            if (this.italicsing) {
                super.write("<w:i />");
            }
            super.write("</w:rPr>");
        }
        super.write("<w:t xml:space=\"preserve\" >");
        super.write(content);
        super.write("</w:t>");
        super.write("</w:r>");
    }

    private void startParagraphIfNeeded() throws IOException {
        if (this.paragraphsStack.isEmpty()) {
            this.internalStartParagraph(false);
        }
    }

    private void internalStartParagraph(boolean containerIsList) throws IOException {
        super.write("<w:p>");
        this.paragraphsStack.push(containerIsList);
    }

    private void internalEndParagraph() throws IOException {
        super.write("</w:p>");
        this.paragraphsStack.pop();
    }

    public void startListItem() throws IOException {
        this.internalStartParagraph(true);
        boolean ordered = super.getCurrentListOrder();
        super.write("<w:pPr>");
        super.write("<w:pStyle w:val=\"Paragraphedeliste\" />");
        super.write("<w:numPr>");
        int ilvlVal = super.getCurrentListIndex();
        super.write("<w:ilvl w:val=\"");
        super.write(String.valueOf(ilvlVal));
        super.write("\" />");
        int numIdVal = ordered ? 2 : 1;
        super.write("<w:numId w:val=\"");
        super.write(String.valueOf(numIdVal));
        super.write("\" />");
        super.write("</w:numPr>");
        super.write("</w:pPr>");
    }

    public void endListItem() throws IOException {
        this.internalEndParagraph();
    }

    public void startParagraph() throws IOException {
        this.internalStartParagraph(false);
    }

    public void endParagraph() throws IOException {
        this.internalEndParagraph();
    }

    public void startHeading(int level) {
    }

    public void endHeading(int level) {
    }

    protected void doEndUnorderedList() throws IOException {
    }

    protected void doEndOrderedList() throws IOException {
    }

    protected void doStartUnorderedList() throws IOException {
    }

    protected void doStartOrderedList() throws IOException {
    }

    public void handleReference(String ref, String label) throws IOException {
        HyperlinkRegistry registry = this.getHyperlinkRegistry();
        String rId = registry.registerHyperlink(ref);
        String hyperlinkStyleName = "Lienhypertexte";
        super.write("<w:hyperlink r:id=\"");
        super.write(rId);
        super.write("\" w:history=\"1\"> ");
        super.write("<w:proofErr w:type=\"spellStart\" />");
        super.write("<w:r w:rsidRPr=\"001D30B5\">");
        super.write("<w:rPr>");
        super.write("<w:rStyle w:val=\"");
        super.write(hyperlinkStyleName);
        super.write("\" />");
        super.write("</w:rPr>");
        super.write("<w:t>");
        super.write(label);
        super.write("</w:t>");
        super.write("</w:r>");
        super.write("<w:proofErr w:type=\"spellEnd\" />");
        super.write("</w:hyperlink>");
    }

    public void handleImage(String ref, String label) throws IOException {
    }

    private HyperlinkRegistry getHyperlinkRegistry() {
        if (this.hyperlinkRegistry != null) {
            return this.hyperlinkRegistry;
        }
        IContext context = this.getContext();
        if (context == null) {
            this.hyperlinkRegistry = new HyperlinkRegistry();
            return this.hyperlinkRegistry;
        }
        String key = HyperlinkUtils.getHyperlinkRegistryKey(this.getEntryName());
        this.hyperlinkRegistry = (HyperlinkRegistry)context.get(key);
        if (this.hyperlinkRegistry == null) {
            this.hyperlinkRegistry = new HyperlinkRegistry();
            context.put(key, (Object)this.hyperlinkRegistry);
        }
        return this.hyperlinkRegistry;
    }
}

