/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.docx.DocxConstants;
import fr.opensagres.xdocreport.document.docx.images.DocxImageRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.DefaultStyle;
import fr.opensagres.xdocreport.document.docx.preprocessor.DocxPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.InitialHyperlinkMap;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.contenttypes.DocxContentTypesPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.numbering.DocxNumberingPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.rels.DocxDocumentXMLRelsPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.styles.DocxStylesPreprocessor;
import fr.opensagres.xdocreport.document.docx.template.DocxContextHelper;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocxReport
extends AbstractXDocReport {
    private static final long serialVersionUID = -2323716817951928168L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"word/document.xml", "word/styles.xml", "word/header*.xml", "word/footer*.xml", "word/_rels/*.xml.rels", "word/numbering.xml"};
    private Set<String> allEntryNamesHyperlinks;
    private Set<String> modifiedEntryNamesHyperlinks;
    private DefaultStyle defaultStyle = new DefaultStyle();

    public String getKind() {
        return DocumentKind.DOCX.name();
    }

    protected void registerPreprocessors() {
        super.addPreprocessor("word/styles.xml", DocxStylesPreprocessor.INSTANCE);
        super.addPreprocessor("word/document.xml", DocxPreprocessor.INSTANCE);
        super.addPreprocessor("word/header*.xml", DocxPreprocessor.INSTANCE);
        super.addPreprocessor("word/footer*.xml", DocxPreprocessor.INSTANCE);
        super.addPreprocessor("[Content_Types].xml", DocxContentTypesPreprocessor.INSTANCE);
        super.addPreprocessor("word/_rels/*.xml.rels", DocxDocumentXMLRelsPreprocessor.INSTANCE);
        super.addPreprocessor("word/numbering.xml", DocxNumberingPreprocessor.INSTANCE);
    }

    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    public MimeMapping getMimeMapping() {
        return DocxConstants.MIME_MAPPING;
    }

    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new DocxImageRegistry(readerProvider, writerProvider, outputStreamProvider);
    }

    protected void onBeforePreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onBeforePreprocessing(sharedContext, preprocessedArchive);
        Set xmlRelsEntryNames = preprocessedArchive.getEntryNames("word/_rels/*.xml.rels");
        this.allEntryNamesHyperlinks = new HashSet<String>();
        String entryName = null;
        for (String relsEntryName : xmlRelsEntryNames) {
            HyperlinkContentHandler contentHandler = new HyperlinkContentHandler();
            Reader reader = preprocessedArchive.getEntryReader(relsEntryName);
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(new InputSource(reader));
                if (contentHandler.getHyperlinks() == null) continue;
                entryName = HyperlinkUtils.getEntryNameWithoutRels(relsEntryName);
                HyperlinkUtils.putInitialHyperlinkMap(entryName, sharedContext, contentHandler.getHyperlinks());
                this.allEntryNamesHyperlinks.add(entryName);
            }
            catch (SAXException e) {
                throw new XDocReportException((Throwable)e);
            }
            catch (IOException e) {
                throw new XDocReportException((Throwable)e);
            }
        }
        sharedContext.put("___DefaultStyle", this.defaultStyle);
    }

    protected void onAfterPreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onAfterPreprocessing(sharedContext, preprocessedArchive);
        if (sharedContext != null) {
            InitialHyperlinkMap hyperlinkMap = null;
            this.modifiedEntryNamesHyperlinks = new HashSet<String>();
            for (String entryName : this.allEntryNamesHyperlinks) {
                hyperlinkMap = HyperlinkUtils.getInitialHyperlinkMap(entryName, sharedContext);
                if (hyperlinkMap == null || !hyperlinkMap.isModified()) continue;
                this.modifiedEntryNamesHyperlinks.add(entryName);
            }
        }
    }

    protected void onBeforeProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onBeforeProcessTemplateEngine(context, outputArchive);
        for (String entryName : this.modifiedEntryNamesHyperlinks) {
            DocxContextHelper.putHyperlinkRegistry(context, entryName, new HyperlinkRegistry());
        }
        DocxContextHelper.putDefaultStyle(context, this.defaultStyle);
        DocxContextHelper.getStylesGenerator(context);
    }

    protected void onAfterProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onAfterProcessTemplateEngine(context, outputArchive);
    }
}

