/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.InitialHyperlinkMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkUtils {
    private static final String[] DOT_SLASH = new String[]{".", "/"};
    private static final String[] UNDERSCORE_UNDERSCORE = new String[]{"_", "_"};
    private static final String[] RELS = new String[]{".rels", "/_rels"};
    private static final String[] BLANCK = new String[]{"", ""};

    public static InitialHyperlinkMap getInitialHyperlinkMap(String entryName, Map<String, Object> sharedContext) {
        if (sharedContext == null) {
            return null;
        }
        return (InitialHyperlinkMap)sharedContext.get(HyperlinkUtils.getHyperlinkRegistryKey(entryName));
    }

    public static void putInitialHyperlinkMap(String entryName, Map<String, Object> sharedContext, InitialHyperlinkMap hyperlinkMap) {
        sharedContext.put(HyperlinkUtils.getHyperlinkRegistryKey(entryName), hyperlinkMap);
    }

    public static String getHyperlinkRegistryKey(String entryName) {
        entryName = StringUtils.replaceEach((String)entryName, (String[])DOT_SLASH, (String[])UNDERSCORE_UNDERSCORE);
        return "___HyperlinkRegistry" + entryName;
    }

    public static String getEntryNameWithoutRels(String relsEntryName) {
        return StringUtils.replaceEach((String)relsEntryName, (String[])RELS, (String[])BLANCK);
    }
}

