/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.textstyling;

import fr.opensagres.xdocreport.document.docx.preprocessor.DefaultStyle;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.HyperlinkUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.numbering.NumberingRegistry;
import fr.opensagres.xdocreport.document.docx.template.DocxContextHelper;
import fr.opensagres.xdocreport.document.docx.textstyling.IDocxStylesGenerator;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.textstyling.AbstractDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.util.Stack;

public class DocxDocumentHandler
extends AbstractDocumentHandler {
    private boolean bolding;
    private boolean italicsing;
    private Stack<Boolean> paragraphsStack;
    private HyperlinkRegistry hyperlinkRegistry;
    protected final IDocxStylesGenerator styleGen;
    private final NumberingRegistry numberingRegistry;
    private DefaultStyle defaultStyle;
    private boolean insideHeader;
    private boolean paragraphWasInserted;
    private Stack<Integer> numbersStack;
    private int currentNumId;

    public DocxDocumentHandler(BufferedElement parent, IContext context, String entryName) {
        super(parent, context, entryName);
        this.styleGen = DocxContextHelper.getStylesGenerator(context);
        this.defaultStyle = DocxContextHelper.getDefaultStyle(context);
        this.numberingRegistry = this.getNumberingRegistry(context);
        this.insideHeader = false;
        this.paragraphWasInserted = false;
        this.numbersStack = new Stack();
    }

    public void startDocument() {
        this.bolding = false;
        this.italicsing = false;
        this.paragraphsStack = new Stack();
    }

    public void endDocument() throws IOException {
        this.endParagraphIfNeeded();
    }

    private void endParagraphIfNeeded() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            this.paragraphsStack.size();
            for (int i = 0; i < this.paragraphsStack.size(); ++i) {
                this.endParagraph();
            }
            this.paragraphsStack.clear();
        }
    }

    private void closeCurrentParagraph() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            this.endParagraph();
        }
    }

    public void startBold() {
        this.bolding = true;
    }

    public void endBold() {
        this.bolding = false;
    }

    public void startItalics() {
        this.italicsing = true;
    }

    public void endItalics() {
        this.italicsing = false;
    }

    public void handleString(String content) throws IOException {
        if (this.insideHeader) {
            super.write(content);
        } else {
            this.startParagraphIfNeeded();
            super.write("<w:r>");
            if (this.bolding || this.italicsing) {
                super.write("<w:rPr>");
                if (this.bolding) {
                    super.write("<w:b />");
                }
                if (this.italicsing) {
                    super.write("<w:i />");
                }
                super.write("</w:rPr>");
            }
            super.write("<w:t xml:space=\"preserve\" >");
            super.write(content);
            super.write("</w:t>");
            super.write("</w:r>");
        }
    }

    private void startParagraphIfNeeded() throws IOException {
        if (this.paragraphWasInserted && this.paragraphsStack.isEmpty()) {
            this.startParagraph(false);
        }
    }

    private void startParagraph(boolean realParagraph) throws IOException {
        this.paragraphWasInserted = true;
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        super.write("<w:p>");
        this.paragraphsStack.push(realParagraph);
    }

    public void startParagraph() throws IOException {
        this.closeCurrentParagraph();
        this.startParagraph(true);
    }

    public void endParagraph() throws IOException {
        super.write("</w:p>");
        this.paragraphsStack.pop();
    }

    public void startListItem() throws IOException {
        this.closeCurrentParagraph();
        this.startParagraph(false);
        super.write("<w:pPr>");
        super.write("<w:numPr>");
        int ilvlVal = super.getCurrentListIndex();
        super.write("<w:ilvl w:val=\"");
        super.write(String.valueOf(ilvlVal));
        super.write("\" />");
        int numIdVal = this.getCurrentNumId();
        super.write("<w:numId w:val=\"");
        super.write(String.valueOf(numIdVal));
        super.write("\" />");
        super.write("</w:numPr>");
        super.write("</w:pPr>");
    }

    public void endListItem() throws IOException {
    }

    public void startHeading(int level) throws IOException {
        this.closeCurrentParagraph();
        this.startParagraph(false);
        String headingStyleName = this.styleGen.getHeaderStyleId(level, this.defaultStyle);
        super.write("<w:pPr>");
        super.write("<w:pStyle w:val=\"");
        super.write(headingStyleName);
        super.write("\" /></w:pPr><w:r><w:t>");
        this.insideHeader = true;
    }

    public void endHeading(int level) throws IOException {
        super.write("</w:t></w:r>");
        this.endParagraph();
        this.insideHeader = false;
    }

    protected void doStartOrderedList() throws IOException {
        if (this.getCurrentListIndex() < 1) {
            int numId;
            int abstractNumId = this.styleGen.getAbstractNumIdForList(true, this.defaultStyle);
            this.currentNumId = numId = this.getNumberingRegistry().addNum(abstractNumId, this.getMaxNumId()).getNumId();
        }
    }

    protected void doStartUnorderedList() throws IOException {
        if (this.getCurrentListIndex() < 1) {
            int numId;
            int abstractNumId = this.styleGen.getAbstractNumIdForList(false, this.defaultStyle);
            this.currentNumId = numId = this.getNumberingRegistry().addNum(abstractNumId, this.getMaxNumId()).getNumId();
        }
    }

    private Integer getMaxNumId() {
        if (this.defaultStyle == null) {
            return null;
        }
        return this.defaultStyle.getMaxNumId();
    }

    protected void doEndUnorderedList() throws IOException {
    }

    protected void doEndOrderedList() throws IOException {
    }

    private int getCurrentNumId() {
        return this.currentNumId;
    }

    public void handleReference(String ref, String label) throws IOException {
        if (ref != null) {
            HyperlinkRegistry registry = this.getHyperlinkRegistry();
            String rId = registry.registerHyperlink(ref);
            String hyperlinkStyleName = this.styleGen.getHyperLinkStyleId(this.defaultStyle);
            super.write("<w:hyperlink r:id=\"");
            super.write(rId);
            super.write("\" w:history=\"1\"> ");
            super.write("<w:proofErr w:type=\"spellStart\" />");
            super.write("<w:r w:rsidRPr=\"001D30B5\">");
            super.write("<w:rPr>");
            super.write("<w:rStyle w:val=\"");
            super.write(hyperlinkStyleName);
            super.write("\" />");
            super.write("</w:rPr>");
            super.write("<w:t>");
            super.write(label != null ? label : ref);
            super.write("</w:t>");
            super.write("</w:r>");
            super.write("<w:proofErr w:type=\"spellEnd\" />");
            super.write("</w:hyperlink>");
        }
    }

    public void handleImage(String ref, String label) throws IOException {
    }

    private NumberingRegistry getNumberingRegistry() {
        return this.numberingRegistry;
    }

    private NumberingRegistry getNumberingRegistry(IContext context) {
        if (context == null) {
            return new NumberingRegistry();
        }
        NumberingRegistry registry = DocxContextHelper.getNumberingRegistry(context);
        if (registry == null) {
            registry = new NumberingRegistry();
            DocxContextHelper.putNumberingRegistry(context, registry);
        }
        return registry;
    }

    private HyperlinkRegistry getHyperlinkRegistry() {
        if (this.hyperlinkRegistry != null) {
            return this.hyperlinkRegistry;
        }
        IContext context = this.getContext();
        if (context == null) {
            this.hyperlinkRegistry = new HyperlinkRegistry();
            return this.hyperlinkRegistry;
        }
        String key = HyperlinkUtils.getHyperlinkRegistryKey(this.getEntryName());
        this.hyperlinkRegistry = (HyperlinkRegistry)context.get(key);
        if (this.hyperlinkRegistry == null) {
            this.hyperlinkRegistry = new HyperlinkRegistry();
            context.put(key, (Object)this.hyperlinkRegistry);
        }
        return this.hyperlinkRegistry;
    }
}

