/**
 * Copyright (C) 2011 Angelo Zerr <angelo.zerr@gmail.com> and Pascal Leclercq <pascal.leclercq@gmail.com>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks;

/**
 * Java model of a Relationship type of Hyperlink declared in the "word/_rels/document.xml.rels".
 * 
 * <pre>
 * 	<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink" 
 * 				  Target="mailto:$mail" 
 * 				  TargetMode="External" />
 * </pre>
 */
public class HyperlinkInfo
{

    private final String id;

    private final String target;

    private final String targetMode;

    public HyperlinkInfo( String id, String target, String targetMode )
    {
        this.id = id;
        this.target = target;
        this.targetMode = targetMode;
    }

    /**
     * Returns the Relationship/@Id value.
     * 
     * @return
     */
    public String getId()
    {
        return id;
    }

    /**
     * Returns the Relationship/@Target value.
     * 
     * @return
     */
    public String getTarget()
    {
        return target;
    }

    /**
     * Returns the Relationship/@TargetMode value.
     * 
     * @return
     */
    public String getTargetMode()
    {
        return targetMode;
    }

}
