/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ProcessRowResult;
import fr.opensagres.xdocreport.document.preprocessor.sax.RowBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocument;
import fr.opensagres.xdocreport.template.formatter.Directive;
import fr.opensagres.xdocreport.template.formatter.DirectivesStack;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformedBufferedDocumentContentHandler<Document extends TransformedBufferedDocument>
extends BufferedDocumentContentHandler<Document> {
    private static final String _ELEMENT_ID = "_elementId";
    private static final String AFTER_TOKEN = "@/";
    private static final String BEFORE_TOKEN = "@";
    private final FieldsMetadata fieldsMetadata;
    private final IDocumentFormatter formatter;
    private final Map<String, Object> sharedContext;
    private final DirectivesStack directives;
    private int nbLoopDirectiveToRemove = 0;
    private int variableIndex;
    private final String entryName;
    private boolean hasStartDirective;
    private String startNoParse;
    private String endNoParse;

    protected TransformedBufferedDocumentContentHandler(String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formater, Map<String, Object> sharedContext) {
        this.fieldsMetadata = fieldsMetadata;
        this.formatter = formater;
        this.sharedContext = sharedContext;
        this.directives = new DirectivesStack();
        this.variableIndex = 0;
        this.entryName = entryName;
        this.hasStartDirective = false;
        this.startNoParse = Directive.getStartNoParse((IDocumentFormatter)formater, (FieldsMetadata)fieldsMetadata);
        this.endNoParse = Directive.getEndNoParse((IDocumentFormatter)formater, (FieldsMetadata)fieldsMetadata);
    }

    @Override
    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.getElementIndex() == 0) {
            String endNoParse = this.getEndNoParse();
            String endDirective = this.formatter != null ? this.formatter.getEndDocumentDirective() : null;
            StringBuilder directive = new StringBuilder();
            if (endNoParse != null) {
                directive.append(endNoParse);
            }
            if (StringUtils.isNotEmpty((String)endDirective)) {
                directive.append(endDirective);
            }
            if (StringUtils.isNotEmpty((String)directive.toString())) {
                this.getCurrentElement().getEndTagElement().setBefore(directive.toString());
            }
        } else if (this.getElementIndex() == 1 && !this.hasStartDirective) {
            this.hasStartDirective = true;
            String startDirective = this.formatter != null ? this.formatter.getStartDocumentDirective() : null;
            String startNoParse = this.getStartNoParse();
            StringBuilder directive = new StringBuilder();
            if (StringUtils.isNotEmpty((String)startDirective)) {
                directive.append(startDirective);
            }
            if (startNoParse != null) {
                directive.append(startNoParse);
            }
            if (StringUtils.isNotEmpty((String)directive.toString())) {
                this.getCurrentElement().getStartTagElement().setBefore(directive.toString());
            }
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    @Override
    protected void flushCharacters(String characters) {
        super.flushCharacters(this.processRowIfNeeded(characters));
    }

    public String processRowIfNeeded(String content) {
        return this.processRowIfNeeded(content, false);
    }

    public String processRowIfNeeded(String content, boolean forceAsField) {
        ProcessRowResult result = this.getProcessRowResult(content, forceAsField);
        return result.getContent();
    }

    public ProcessRowResult getProcessRowResult(String content, boolean forceAsField) {
        RowBufferedRegion currentRow = ((TransformedBufferedDocument)this.bufferedDocument).getCurrentTableRow();
        if (currentRow != null && this.formatter != null && this.fieldsMetadata != null) {
            Collection fieldsAsList = this.fieldsMetadata.getFieldsAsList();
            if (!currentRow.isLoopTemplateDirectiveInitilalized()) {
                for (String fieldName : fieldsAsList) {
                    String itemNameList;
                    if (!content.contains(fieldName) || !StringUtils.isNotEmpty((String)(itemNameList = this.formatter.extractItemNameList(content, fieldName, forceAsField)))) continue;
                    currentRow.initializeLoopTemplateDirective(itemNameList, this.formatter, this.getStartNoParse(), this.getEndNoParse());
                    break;
                }
            }
            if (currentRow.isLoopTemplateDirectiveInitilalized()) {
                for (String fieldName : fieldsAsList) {
                    String newContent;
                    if (!content.contains(fieldName) || (newContent = this.formatter.formatAsFieldItemList(content, fieldName, forceAsField)) == null) continue;
                    return new ProcessRowResult(newContent, fieldName, currentRow.getItemNameList(), currentRow.getStartLoopDirective(), currentRow.getEndLoopDirective());
                }
            }
        }
        return new ProcessRowResult(content, null, null, null, null);
    }

    public Map<String, Object> getSharedContext() {
        return this.sharedContext;
    }

    public boolean hasSharedContext() {
        return this.sharedContext != null;
    }

    public FieldsMetadata getFieldsMetadata() {
        return this.fieldsMetadata;
    }

    public IDocumentFormatter getFormatter() {
        return this.formatter;
    }

    public DirectivesStack getDirectives() {
        return this.directives;
    }

    protected String getBeforeRowToken() {
        if (this.fieldsMetadata == null) {
            return "@before-row";
        }
        return this.fieldsMetadata.getBeforeRowToken();
    }

    protected String getAfterRowToken() {
        if (this.fieldsMetadata == null) {
            return "@after-row";
        }
        return this.fieldsMetadata.getAfterRowToken();
    }

    protected String getBeforeTableCellToken() {
        if (this.fieldsMetadata == null) {
            return "@before-cell";
        }
        return this.fieldsMetadata.getBeforeTableCellToken();
    }

    protected String getAfterTableCellToken() {
        if (this.fieldsMetadata == null) {
            return "@after-cell";
        }
        return this.fieldsMetadata.getAfterTableCellToken();
    }

    public int extractListDirectiveInfo(String characters, boolean dontRemoveListDirectiveInfo) {
        if (this.formatter == null || characters == null) {
            return 0;
        }
        return this.formatter.extractListDirectiveInfo(characters, this.getDirectives(), dontRemoveListDirectiveInfo);
    }

    public int extractListDirectiveInfo(String characters) {
        int i = this.extractListDirectiveInfo(characters, ((TransformedBufferedDocument)this.bufferedDocument).getCurrentTableRow() != null);
        if (i < 0) {
            this.nbLoopDirectiveToRemove += -i;
        }
        return i;
    }

    protected boolean isTable(String uri, String localName, String name) {
        return ((TransformedBufferedDocument)this.bufferedDocument).isTable(uri, localName, name);
    }

    protected abstract String getTableRowName();

    protected abstract String getTableCellName();

    protected boolean isTableRow(String uri, String localName, String name) {
        return ((TransformedBufferedDocument)this.bufferedDocument).isTableRow(uri, localName, name);
    }

    public boolean processScriptBefore(String fieldName) {
        int index = this.getIndexOfScript(fieldName, true);
        if (index == -1) {
            return false;
        }
        String beforeElementName = fieldName.substring(0, index);
        if (StringUtils.isNotEmpty((String)beforeElementName)) {
            if (beforeElementName.equals(this.getBeforeRowToken())) {
                beforeElementName = this.getTableRowName();
            } else if (beforeElementName.equals(this.getBeforeTableCellToken())) {
                beforeElementName = this.getTableCellName();
            } else if (beforeElementName.startsWith(BEFORE_TOKEN)) {
                beforeElementName = beforeElementName.substring(BEFORE_TOKEN.length(), beforeElementName.length());
            }
            BufferedElement elementInfo = super.findParentElementInfo(beforeElementName);
            if (elementInfo == null) {
                return false;
            }
            String before = fieldName.substring(index, fieldName.length());
            before = this.formatDirective(before);
            elementInfo.setContentBeforeStartTagElement(before);
            return true;
        }
        return false;
    }

    private int getIndexOfScript(String fieldName, boolean before) {
        if (fieldName == null) {
            return -1;
        }
        if (before) {
            if (this.formatter == null) {
                if (fieldName.startsWith(this.getBeforeRowToken())) {
                    return this.getBeforeRowToken().length();
                }
                if (fieldName.startsWith(this.getBeforeTableCellToken())) {
                    return this.getBeforeTableCellToken().length();
                }
                return -1;
            }
            if (!(fieldName.startsWith(BEFORE_TOKEN) || fieldName.startsWith(this.getBeforeRowToken()) || fieldName.startsWith(this.getBeforeTableCellToken()))) {
                return -1;
            }
        } else {
            if (this.formatter == null) {
                if (fieldName.startsWith(this.getAfterRowToken())) {
                    return this.getAfterRowToken().length();
                }
                if (fieldName.startsWith(this.getAfterTableCellToken())) {
                    return this.getAfterTableCellToken().length();
                }
                return -1;
            }
            if (!(fieldName.startsWith(AFTER_TOKEN) || fieldName.startsWith(this.getAfterRowToken()) || fieldName.startsWith(this.getAfterTableCellToken()))) {
                return -1;
            }
        }
        return this.formatter.getIndexOfScript(fieldName);
    }

    public boolean processScriptAfter(String fieldName) {
        int index = this.getIndexOfScript(fieldName, false);
        if (index == -1) {
            return false;
        }
        String afterElementName = fieldName.substring(0, index);
        if (StringUtils.isNotEmpty((String)afterElementName)) {
            if (afterElementName.equals(this.getAfterRowToken())) {
                afterElementName = this.getTableRowName();
            } else if (afterElementName.equals(this.getAfterTableCellToken())) {
                afterElementName = this.getTableCellName();
            } else if (afterElementName.startsWith(AFTER_TOKEN)) {
                afterElementName = afterElementName.substring(AFTER_TOKEN.length(), afterElementName.length());
            }
            BufferedElement elementInfo = super.findParentElementInfo(afterElementName);
            if (elementInfo == null) {
                return false;
            }
            String after = fieldName.substring(index, fieldName.length());
            after = this.formatDirective(after);
            elementInfo.setContentAfterEndTagElement(after);
            return true;
        }
        return false;
    }

    @Override
    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (this.getElementIndex() == 0) {
            // empty if block
        }
        if (this.isTable(uri, localName, name) && this.nbLoopDirectiveToRemove > 0) {
            for (int i = 0; i < this.nbLoopDirectiveToRemove; ++i) {
                if (this.getDirectives().isEmpty()) continue;
                this.getDirectives().pop();
            }
            this.nbLoopDirectiveToRemove = 0;
        }
        super.doEndElement(uri, localName, name);
    }

    public FieldMetadata getFieldAsTextStyling(String content) {
        if (this.formatter != null && this.fieldsMetadata != null) {
            return this.fieldsMetadata.getFieldAsTextStyling(content);
        }
        return null;
    }

    public String registerBufferedElement(long variableIndex, BufferedElement element) {
        HashMap<String, BufferedElement> elements = (HashMap<String, BufferedElement>)this.getSharedContext().get("___Elements");
        if (elements == null) {
            elements = new HashMap<String, BufferedElement>();
        }
        String id = TransformedBufferedDocumentContentHandler.generateKey(variableIndex);
        elements.put(id, element);
        return id;
    }

    public static String generateKey(long variableIndex) {
        StringBuilder key = new StringBuilder();
        key.append(variableIndex);
        key.append(_ELEMENT_ID);
        return key.toString();
    }

    public long getVariableIndex() {
        return this.variableIndex++;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String formatDirective(String directive) {
        return Directive.formatDirective((String)directive, (String)this.getStartNoParse(), (String)this.getEndNoParse());
    }

    public String getStartNoParse() {
        return this.startNoParse;
    }

    public String getEndNoParse() {
        return this.endNoParse;
    }

    @Override
    protected abstract Document createDocument();
}

