/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.google.code.appengine.awt.Color;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;

public class ExtendedParagraph
extends Paragraph
implements IITextContainer {
    private static final long serialVersionUID = 664309269352903329L;
    public static final Color TRANSPARENT_COLOR = Color.WHITE;
    private IITextContainer container;
    protected PdfPCell wrapperCell;
    protected PdfPTable wrapperTable;

    public ExtendedParagraph() {
    }

    public ExtendedParagraph(Paragraph paragraph) {
        super((Phrase)paragraph);
    }

    @Override
    public void addElement(Element element) {
        super.add(this.size(), (Object)element);
    }

    @Override
    public IITextContainer getITextContainer() {
        return this.container;
    }

    @Override
    public void setITextContainer(IITextContainer container) {
        this.container = container;
    }

    private PdfPCell createCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPadding(0.0f);
        cell.setUseBorderPadding(true);
        cell.getColumn().setAdjustFirstLine(false);
        return cell;
    }

    private PdfPTable createTable(PdfPCell cell) {
        PdfPTable table = new PdfPTable(1);
        table.setWidthPercentage(100.0f);
        table.setSplitLate(false);
        table.addCell(cell);
        return table;
    }

    protected PdfPCell getWrapperCell() {
        if (this.wrapperCell == null) {
            this.wrapperCell = this.createCell();
        }
        return this.wrapperCell;
    }

    protected PdfPTable createWrapperTable(PdfPCell wrapperCell, boolean addParagraph) {
        PdfPTable wrapperTable = null;
        if (wrapperCell != null) {
            if (addParagraph) {
                wrapperCell.addElement((Element)this);
            }
            wrapperTable = this.createTable(wrapperCell);
            if (this.getSpacingBefore() > 0.0f || this.getSpacingAfter() > 0.0f) {
                wrapperTable.setSpacingBefore(this.getSpacingBefore());
                this.setSpacingBefore(0.0f);
                wrapperTable.setSpacingAfter(this.getSpacingAfter());
                this.setSpacingAfter(0.0f);
            }
            if (this.getIndentationLeft() > 0.0f || this.getIndentationRight() > 0.0f) {
                PdfPCell outerCell = this.createCell();
                outerCell.setPaddingLeft(this.getIndentationLeft());
                this.setIndentationLeft(0.0f);
                outerCell.setPaddingRight(this.getIndentationRight());
                this.setIndentationRight(0.0f);
                outerCell.addElement((Element)wrapperTable);
                wrapperTable = this.createTable(outerCell);
            }
        }
        return wrapperTable;
    }

    public Element getElement() {
        if (this.wrapperCell != null && this.wrapperTable == null) {
            this.wrapperTable = this.createWrapperTable(this.wrapperCell, true);
        }
        return this.wrapperTable != null ? this.wrapperTable : this;
    }

    public boolean hasBorders() {
        return this.wrapperCell != null && this.wrapperCell.hasBorders();
    }

    public boolean hasBackgroundColor() {
        return this.wrapperCell != null && this.wrapperCell.getBackgroundColor() != null && !TRANSPARENT_COLOR.equals((Object)this.wrapperCell.getBackgroundColor());
    }

    public void setSpacingBefore(Paragraph paragraph) {
        this.setSpacingBefore(paragraph.getSpacingBefore());
    }

    public void setSpacingAfter(Paragraph paragraph) {
        this.setSpacingAfter(paragraph.getSpacingAfter());
    }

    public void setIndentation(Paragraph paragraph) {
        this.setIndentationLeft(paragraph.getIndentationLeft());
        this.setIndentationRight(paragraph.getIndentationRight());
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.getWrapperCell().setBackgroundColor(backgroundColor);
    }

    public void setBorderWidthTop(float borderWidthTop) {
        this.getWrapperCell().setBorderWidthTop(borderWidthTop);
    }

    public void setBorderColorTop(Color borderColorTop) {
        this.getWrapperCell().setBorderColorTop(borderColorTop);
    }

    public void setBorderWidthBottom(float borderWidthBottom) {
        this.getWrapperCell().setBorderWidthBottom(borderWidthBottom);
    }

    public void setBorderColorBottom(Color borderColorBottom) {
        this.getWrapperCell().setBorderColorBottom(borderColorBottom);
    }

    public void setBorderWidthLeft(float borderWidthLeft) {
        this.getWrapperCell().setBorderWidthLeft(borderWidthLeft);
    }

    public void setBorderColorLeft(Color borderColorLeft) {
        this.getWrapperCell().setBorderColorLeft(borderColorLeft);
    }

    public void setBorderWidthRight(float borderWidthRight) {
        this.getWrapperCell().setBorderWidthRight(borderWidthRight);
    }

    public void setBorderColorRight(Color borderColorRight) {
        this.getWrapperCell().setBorderColorRight(borderColorRight);
    }

    public void setBorderPadding(float padding) {
        this.getWrapperCell().setPadding(padding);
    }

    public void setBorderPaddingLeft(float paddingLeft) {
        this.getWrapperCell().setPaddingLeft(paddingLeft);
    }

    public void setBorderPaddingRight(float paddingRight) {
        this.getWrapperCell().setPaddingRight(paddingRight);
    }

    public void setBorderPaddingBottom(float paddingBottom) {
        this.getWrapperCell().setPaddingBottom(paddingBottom);
    }

    public void setBorderPaddingTop(float paddingTop) {
        this.getWrapperCell().setPaddingTop(paddingTop);
    }
}

