/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension.font;

import com.google.code.appengine.awt.Color;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.Type3Font;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;

public abstract class AbstractFontRegistry
implements IFontProvider {
    private boolean systemEncodingDetermined;
    private String systemEncoding;
    private static boolean fontRegistryInitialized = false;

    @Override
    public Font getFont(String familyName, String encoding, float size, int style, Color color) {
        this.initFontRegistryIfNeeded();
        if (familyName != null) {
            familyName = this.resolveFamilyName(familyName, style);
        }
        try {
            return FontFactory.getFont((String)familyName, (String)encoding, (float)size, (int)style, (Color)color);
        }
        catch (ExceptionConverter e) {
            return new Font(-1, size, style, color);
        }
    }

    private void initFontRegistryIfNeeded() {
        if (!fontRegistryInitialized) {
            ExtendedBaseFont.clearBuiltinFonts();
            FontFactory.registerDirectories();
            fontRegistryInitialized = true;
        }
    }

    public boolean isBold(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 1) == 1;
    }

    public boolean isItalic(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 2) == 2;
    }

    public boolean isUnderlined(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 4) == 4;
    }

    public boolean isStrikethru(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 8) == 8;
    }

    public String getSystemEncoding() {
        if (this.systemEncodingDetermined) {
            return this.systemEncoding;
        }
        this.systemEncoding = System.getProperty("sun.jnu.encoding");
        if (this.systemEncoding != null && this.systemEncoding.length() > 0) {
            this.systemEncodingDetermined = true;
            return this.systemEncoding;
        }
        this.systemEncoding = System.getProperty("ibm.system.encoding");
        if (this.systemEncoding != null && this.systemEncoding.length() > 0) {
            this.systemEncodingDetermined = true;
            return this.systemEncoding;
        }
        this.systemEncoding = FontFactory.defaultEncoding;
        this.systemEncodingDetermined = true;
        return this.systemEncoding;
    }

    protected abstract String resolveFamilyName(String var1, int var2);

    public static class ExtendedBaseFont
    extends Type3Font {
        public ExtendedBaseFont() {
            super(null, false);
        }

        public static void clearBuiltinFonts() {
            BuiltinFonts14.clear();
            BuiltinFonts14.put("Helvetica", PdfName.HELVETICA);
            BuiltinFonts14.put("Helvetica-Bold", PdfName.HELVETICA_BOLD);
            BuiltinFonts14.put("Helvetica-BoldOblique", PdfName.HELVETICA_BOLDOBLIQUE);
            BuiltinFonts14.put("Helvetica-Oblique", PdfName.HELVETICA_OBLIQUE);
        }
    }
}

