/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.itextpdf.text.ChapterAutoNumber;
import com.itextpdf.text.Element;
import com.itextpdf.text.MarkedSection;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Section;
import com.itextpdf.text.pdf.PdfPCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedSection;
import fr.opensagres.xdocreport.itext.extension.IParagraphFactory;
import fr.opensagres.xdocreport.itext.extension.ParagraphFactory;

public class ExtendedChapterAutoNumber
extends ChapterAutoNumber {
    private Paragraph computedTitle = null;
    private PdfPCell cell;
    private Paragraph bookmarkTitleParagraph;

    public ExtendedChapterAutoNumber(Paragraph para) {
        super(para);
    }

    public ExtendedChapterAutoNumber(String title) {
        super(title);
    }

    public Paragraph getTitle() {
        if (this.computedTitle == null) {
            this.bookmarkTitleParagraph = ExtendedSection.ancestorConstructTitle(this.getParagraphFactory(), this.title, this.numbers, this.numberDepth, this.numberStyle);
            this.computedTitle = ExtendedSection.constructTitle(this.getParagraphFactory(), this.bookmarkTitleParagraph, this.numbers, this.numberDepth, this.numberStyle, this.cell);
        }
        return this.computedTitle;
    }

    public Paragraph getBookmarkTitle() {
        return this.bookmarkTitleParagraph;
    }

    public Section addSection(float indentation, Paragraph title, int numberDepth) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        ExtendedSection section = new ExtendedSection(title, numberDepth);
        section.setIndentation(indentation);
        this.add((Element)section);
        return section;
    }

    public MarkedSection addMarkedSection() {
        MarkedSection section = new MarkedSection((Section)new ExtendedSection(null, this.numberDepth + 1));
        this.add((Element)section);
        return section;
    }

    public PdfPCell getPdfPCell() {
        if (this.cell != null) {
            return this.cell;
        }
        this.cell = this.createPdfPCell();
        return this.cell;
    }

    private synchronized PdfPCell createPdfPCell() {
        if (this.cell != null) {
            return this.cell;
        }
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPadding(0.0f);
        return cell;
    }

    protected IParagraphFactory getParagraphFactory() {
        return ParagraphFactory.getDefault();
    }
}

