/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.itextpdf.text.DocListener;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfWriter;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfContentByte;
import fr.opensagres.xdocreport.itext.extension.IPdfAWriterConfiguration;
import java.io.OutputStream;

public class ExtendedPdfAWriter
extends PdfAWriter {
    private final IPdfAWriterConfiguration configuration;

    protected ExtendedPdfAWriter(PdfDocument document, OutputStream os, PdfAConformanceLevel conformanceLevel, IPdfAWriterConfiguration configuration) {
        super(document, os, conformanceLevel);
        this.pdf = document;
        this.configuration = configuration;
        this.directContent = new ExtendedPdfContentByte((PdfWriter)this);
        this.directContentUnder = new ExtendedPdfContentByte((PdfWriter)this);
    }

    public static ExtendedPdfAWriter getInstance(Document document, OutputStream os, IPdfAWriterConfiguration configuration) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        document.addDocListener((DocListener)pdf);
        PdfAConformanceLevel conformanceLevel = null;
        if (configuration != null) {
            conformanceLevel = configuration.getConformanceLevel();
        }
        ExtendedPdfAWriter writer = new ExtendedPdfAWriter(pdf, os, conformanceLevel, configuration);
        pdf.addWriter((PdfWriter)writer);
        return writer;
    }

    public void open() {
        super.open();
        if (this.configuration != null) {
            this.configuration.configureOutputIntents(this);
        }
    }
}

