/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity.discovery;

import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.discovery.ITemplateEngineDiscovery;
import fr.opensagres.xdocreport.template.velocity.VelocityConstants;
import fr.opensagres.xdocreport.template.velocity.cache.XDocReportEntryResourceLoader;
import fr.opensagres.xdocreport.template.velocity.internal.VelocityTemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class VelocityTemplateEngineDiscovery
implements ITemplateEngineDiscovery,
VelocityConstants {
    public ITemplateEngine createTemplateEngine() {
        Properties velocityDefaultProperties = this.getVelocityDefaultProperties();
        Properties xDocReportDefaultProperties = this.getXDocReportDefaultProperties();
        return new VelocityTemplateEngine(this.getVelocityEngineProperties(velocityDefaultProperties, xDocReportDefaultProperties));
    }

    private synchronized Properties getVelocityEngineProperties(Properties velocityDefaultProperties, Properties xDocReportDefaultProperties) {
        boolean hasReportLoaderDefined;
        Properties velocityEngineProperties = new Properties();
        if (velocityDefaultProperties != null) {
            velocityEngineProperties.putAll((Map<?, ?>)velocityDefaultProperties);
        }
        if (!(hasReportLoaderDefined = velocityEngineProperties.containsKey("resource.loader.report.class"))) {
            velocityEngineProperties.setProperty("resource.loaders", "file, class, jar ,report");
            velocityEngineProperties.setProperty("resource.loader.report.class", XDocReportEntryResourceLoader.class.getName());
            velocityEngineProperties.setProperty("resource.loader.report.cache", "true");
            velocityEngineProperties.setProperty("resource.loader.file.modification_check_interval", "1");
        }
        velocityEngineProperties.setProperty("introspector.conversion_handler.class", "none");
        velocityEngineProperties.setProperty("parser.space_gobbling", "bc");
        velocityEngineProperties.setProperty("directive.if.empty_check", "false");
        velocityEngineProperties.setProperty("parser.allow_hyphen_in_identifiers", "true");
        velocityEngineProperties.setProperty("velocimacro.enable_bc_mode", "true");
        velocityEngineProperties.setProperty("event_handler.invalid_references.quiet", "true");
        velocityEngineProperties.setProperty("event_handler.invalid_references.null", "true");
        velocityEngineProperties.setProperty("event_handler.invalid_references.tested", "true");
        if (xDocReportDefaultProperties != null) {
            velocityEngineProperties.putAll((Map<?, ?>)xDocReportDefaultProperties);
        }
        return velocityEngineProperties;
    }

    private synchronized Properties getVelocityDefaultProperties() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream("velocity.properties");
        if (is != null) {
            try {
                Properties p = new Properties();
                p.load(is);
                return p;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized Properties getXDocReportDefaultProperties() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream("xdocreport-velocity.properties");
        if (is != null) {
            try {
                Properties p = new Properties();
                p.load(is);
                return p;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getDescription() {
        return "Manage Velocity template engine.";
    }

    public String getId() {
        return TemplateEngineKind.Velocity.name();
    }
}

