/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.util;

import fr.pilato.elasticsearch.tools.util.SettingsFinder;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsReader {
    private static final Logger logger = LoggerFactory.getLogger(SettingsReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromClasspath(String file) {
        logger.trace("Reading file [{}]...", (Object)file);
        String content = null;
        try (InputStream asStream = SettingsReader.class.getClassLoader().getResourceAsStream(file);){
            if (asStream == null) {
                logger.trace("Can not find [{}] in class loader.", (Object)file);
                String string = null;
                return string;
            }
            content = IOUtils.toString((InputStream)asStream, (String)"UTF-8");
            return StringSubstitutor.replace(content, System.getenv());
        }
        catch (IOException e) {
            logger.warn("Can not read [{}].", (Object)file);
        }
        return StringSubstitutor.replace(content, System.getenv());
    }

    public static String getJsonContent(String root, String subdir, String name) throws IOException {
        String path = root;
        if (root == null) {
            path = SettingsFinder.Defaults.ConfigDir;
        }
        if (subdir != null) {
            path = path + "/" + subdir;
        }
        path = path + "/" + name + SettingsFinder.Defaults.JsonFileExtension;
        logger.debug("Reading file [{}] from the classpath.", (Object)path);
        return SettingsReader.readFileFromClasspath(path);
    }
}

