/*
 * Decompiled with CFR 0.152.
 */
package fr.sertelon.media;

import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public final class IIOProviderContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        ImageIO.scanForPlugins();
    }

    public void contextDestroyed(ServletContextEvent event) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        LocalFilter localFilter = new LocalFilter(Thread.currentThread().getContextClassLoader());
        Iterator<Class<?>> categories = registry.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            Iterator<?> providers = registry.getServiceProviders(category, localFilter, false);
            while (providers.hasNext()) {
                Object provider = providers.next();
                registry.deregisterServiceProvider(provider);
                event.getServletContext().log(String.format("Unregistered locally installed provider class: %s", provider.getClass()));
            }
        }
    }

    static class LocalFilter
    implements ServiceRegistry.Filter {
        private final ClassLoader loader;

        public LocalFilter(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public boolean filter(Object provider) {
            return provider.getClass().getClassLoader() == this.loader;
        }
    }
}

