/*
 * Decompiled with CFR 0.152.
 */
package fr.stardustenterprises.yanl;

import fr.stardustenterprises.plat4k.EnumArchitecture;
import fr.stardustenterprises.plat4k.EnumCPUType;
import fr.stardustenterprises.plat4k.EnumOperatingSystem;
import fr.stardustenterprises.plat4k.Platform;
import fr.stardustenterprises.yanl.api.Context;
import fr.stardustenterprises.yanl.api.UnsupportedPlatformException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfr/stardustenterprises/yanl/PlatformContext;", "Lfr/stardustenterprises/yanl/api/Context;", "()V", "archIdentifier", "", "getArchIdentifier", "()Ljava/lang/String;", "is64Bits", "", "()Z", "osName", "getOsName", "platform", "Lfr/stardustenterprises/plat4k/Platform;", "mapLibraryName", "name", "usePlatformPrefix", "usePlatformSuffix", "yanl"})
public final class PlatformContext
implements Context {
    @NotNull
    private final Platform platform = Platform.Companion.getCurrentPlatform();
    @NotNull
    private final String osName;
    @NotNull
    private final String archIdentifier;
    private final boolean is64Bits;

    public PlatformContext() {
        Platform platform = this.platform;
        EnumOperatingSystem operatingSystem = platform.component1();
        EnumArchitecture architecture = platform.component2();
        if (operatingSystem == EnumOperatingSystem.UNKNOWN || architecture == EnumArchitecture.UNKNOWN) {
            throw new UnsupportedPlatformException("OS: " + operatingSystem.getOsName() + ", arch: " + architecture.getIdentifier(), null, 2, null);
        }
        this.osName = this.platform.getOperatingSystem().getOsName();
        this.archIdentifier = this.platform.getArchitecture().getIdentifier();
        this.is64Bits = this.platform.getArchitecture().getCpuType() == EnumCPUType.X64;
    }

    @Override
    @NotNull
    public String getOsName() {
        return this.osName;
    }

    @Override
    @NotNull
    public String getArchIdentifier() {
        return this.archIdentifier;
    }

    @Override
    public boolean is64Bits() {
        return this.is64Bits;
    }

    @Override
    @NotNull
    public String mapLibraryName(@NotNull String name, boolean usePlatformPrefix, boolean usePlatformSuffix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String libName = name;
        EnumOperatingSystem os = this.platform.getOperatingSystem();
        if (usePlatformPrefix) {
            libName = Intrinsics.stringPlus((String)os.getNativePrefix(), (Object)libName);
        }
        if (usePlatformSuffix) {
            libName = Intrinsics.stringPlus((String)libName, (Object)os.getNativeSuffix());
        }
        return libName;
    }

    @Override
    @NotNull
    public String format(@NotNull String pathFormat, @NotNull String name) {
        return Context.DefaultImpls.format(this, pathFormat, name);
    }
}

