/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.IoC;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.BeanWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MapperProcessor;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import fr.xebia.extras.selma.codegen.TypeConstructorWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;

public class FactoryWrapper {
    public static final String FACTORY_FIELD_TPL = "factory%s";
    public static final String WITH_FACTORIES = "withFactories";
    private final Element annotatedElement;
    private final AnnotationWrapper annotationWrapper;
    private final MapperGeneratorContext context;
    private final HashMap<Factory, String> unusedFactories;
    private final IoC ioC;
    private final List<TypeElement> factoryFields;
    private final ArrayList<Factory> staticFactories;
    private final ArrayList<Factory> genericFactories;

    public FactoryWrapper(AnnotationWrapper mapperAnnotation, MapperGeneratorContext context) {
        this.annotatedElement = mapperAnnotation.getAnnotatedElement();
        this.annotationWrapper = mapperAnnotation;
        this.context = context;
        this.unusedFactories = new HashMap();
        this.factoryFields = new ArrayList<TypeElement>();
        this.staticFactories = new ArrayList();
        this.genericFactories = new ArrayList();
        this.ioC = IoC.valueOf((String)this.annotationWrapper.getAsString("withIoC"));
        this.collectFactories();
    }

    private void collectFactories() {
        List<String> factoryClasses = this.annotationWrapper.getAsStrings(WITH_FACTORIES);
        if (factoryClasses.size() > 0) {
            int factoryMethodCount = 0;
            for (String factoryClass : factoryClasses) {
                TypeElement element = this.context.elements.getTypeElement(factoryClass.replaceAll("\\.class$", ""));
                if ((factoryMethodCount += this.collectFactoryMethods(element, false)) == 0) {
                    this.context.error(element, "No valid factory method found in Factory selma class %s\\n A factory method method is public and returns a type not void, it takes a Class object or no parameter at all.", factoryClass);
                    continue;
                }
                TypeConstructorWrapper constructorWrapper = new TypeConstructorWrapper(this.context, element);
                if (!constructorWrapper.hasDefaultConstructor && element.getKind() != ElementKind.INTERFACE) {
                    this.context.error(element, "No default public constructor found in custom mapping class %s\\n Please add one", factoryClass);
                }
                this.factoryFields.add(element);
            }
        }
    }

    private int collectFactoryMethods(TypeElement element, boolean ignoreAbstract) {
        int factoryMethodCount = 0;
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        for (ExecutableElement method : methods) {
            MethodWrapper methodWrapper = new MethodWrapper(method, (DeclaredType)element.asType(), this.context);
            if (ignoreAbstract && methodWrapper.isAbstract() || !this.isValidFactoryMethod(methodWrapper)) continue;
            this.pushFactoryMethod(element, methodWrapper, ignoreAbstract);
            ++factoryMethodCount;
        }
        return factoryMethodCount;
    }

    private void pushFactoryMethod(TypeElement element, MethodWrapper method, boolean ignoreAbstract) {
        Object res = null;
        String factoryFieldName = ignoreAbstract ? "this" : this.buildFactoryFieldName(element);
        TypeMirror returnType = method.returnType();
        String methodCall = String.format("%s.%s", factoryFieldName, method.getSimpleName());
        Factory factory = new Factory(this.context, method, methodCall);
        if (method.hasTypeParameter()) {
            this.genericFactories.add(factory);
        } else {
            this.staticFactories.add(factory);
        }
        this.unusedFactories.put(factory, String.format("%s.%s", element.getQualifiedName(), method.getSimpleName()));
    }

    private boolean isValidFactoryMethod(MethodWrapper methodWrapper) {
        boolean res = true;
        if (MapperProcessor.exclusions.contains(methodWrapper.getSimpleName())) {
            return false;
        }
        if (!methodWrapper.element().getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.context.warn(methodWrapper.element(), "Factory method should be *public* (Fix modifiers of the method) on %s", methodWrapper.getSimpleName());
            res = false;
        }
        if (methodWrapper.element().getModifiers().contains((Object)Modifier.STATIC)) {
            this.context.warn(methodWrapper.element(), "Factory method can not be *static* (Fix modifiers of the method) on %s", methodWrapper.getSimpleName());
            res = false;
        }
        if (!methodWrapper.isFactory()) {
            this.context.warn(methodWrapper.element(), "Factory method should have a return type and a Class<T> targetType or no parameters(Fix method signature) on %s", methodWrapper.getSimpleName());
            res = false;
        }
        return res;
    }

    private String buildFactoryFieldName(TypeElement element) {
        return String.format(FACTORY_FIELD_TPL, element.getSimpleName());
    }

    public void emitFactoryFields(JavaWriter writer, boolean assign) throws IOException {
        for (TypeElement factoryField : this.factoryFields) {
            String field = String.format(FACTORY_FIELD_TPL, factoryField.getSimpleName().toString());
            if (assign) {
                if (factoryField.getKind() == ElementKind.INTERFACE) continue;
                TypeConstructorWrapper constructorWrapper = new TypeConstructorWrapper(this.context, factoryField);
                writer.emitStatement("this.%s = new %s(%s)", new Object[]{field, factoryField.getQualifiedName().toString(), constructorWrapper.hasMatchingSourcesConstructor ? this.context.newParams() : ""});
                continue;
            }
            writer.emitEmptyLine();
            writer.emitJavadoc("This field is used for custom Mapping", new Object[0]);
            if (this.ioC == IoC.SPRING) {
                writer.emitAnnotation("org.springframework.beans.factory.annotation.Autowired");
            }
            writer.emitField(factoryField.asType().toString(), String.format(FACTORY_FIELD_TPL, factoryField.getSimpleName().toString()), EnumSet.of(Modifier.PRIVATE));
            writer.emitEmptyLine();
            writer.emitJavadoc("Factory setter for " + field, new Object[0]);
            writer.beginMethod("void", "setFactory" + factoryField.getSimpleName(), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[]{factoryField.asType().toString(), "_factory"});
            writer.emitStatement("this.%s = _factory", new Object[]{field});
            writer.endMethod();
            writer.emitEmptyLine();
        }
    }

    public void reportUnused() {
        for (String field : this.unusedFactories.values()) {
            this.context.warn(this.annotatedElement, "Factory method \"%s\" is never used", field);
        }
    }

    public MappingSourceNode generateNewInstanceSourceNodes(InOutType inOutType, BeanWrapper outBeanWrapper) {
        TypeMirror out = inOutType.out();
        for (Factory factory : this.staticFactories) {
            if (!factory.provide(out)) continue;
            this.unusedFactories.remove(factory);
            return factory.buildNewInstanceSourceNode(inOutType);
        }
        Factory found = null;
        for (Factory factory : this.genericFactories) {
            if (!factory.provide(out) || !factory.isLowerClass(found)) continue;
            found = factory;
        }
        if (found != null) {
            this.unusedFactories.remove(found);
            return found.buildNewInstanceSourceNode(inOutType);
        }
        return null;
    }

    public boolean hasFactory(TypeMirror typeMirror) {
        for (Factory factory : this.staticFactories) {
            if (!factory.provide(typeMirror)) continue;
            return true;
        }
        for (Factory factory : this.genericFactories) {
            if (!factory.provide(typeMirror)) continue;
            return true;
        }
        return false;
    }

    private class Factory {
        private final MethodWrapper method;
        private final String methodCall;
        private MapperGeneratorContext context;

        public Factory(MapperGeneratorContext context, MethodWrapper method, String methodCall) {
            this.context = context;
            this.method = method;
            this.methodCall = methodCall;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Factory factory = (Factory)o;
            if (this.method != null ? !this.method.equals(factory.method) : factory.method != null) {
                return false;
            }
            return this.methodCall != null ? this.methodCall.equals(factory.methodCall) : factory.methodCall == null;
        }

        public int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.methodCall != null ? this.methodCall.hashCode() : 0);
            return result;
        }

        public boolean provide(TypeMirror out) {
            return !this.method.hasTypeParameter() ? this.context.type.isSameType(out, this.method.returnType()) : this.context.type.isAssignable(out, this.getUpperBound());
        }

        public MappingSourceNode buildNewInstanceSourceNode(InOutType inOutType) {
            if (!this.method.hasTypeParameter()) {
                return MappingSourceNode.callStaticFactoryOut(inOutType, this.methodCall);
            }
            return MappingSourceNode.callGenericFactoryOut(inOutType, this.methodCall);
        }

        public boolean isLowerClass(Factory factory) {
            boolean res;
            if (factory == null) {
                res = true;
            } else {
                TypeMirror upperBound = this.getUpperBound();
                TypeMirror upperBoundCmp = factory.getUpperBound();
                res = this.context.type.isAssignable(upperBound, upperBoundCmp);
            }
            return res;
        }

        private TypeMirror getUpperBound() {
            return ((TypeVariable)this.method.returnType()).getUpperBound();
        }
    }
}

