/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import javax.lang.model.element.Element;

class Field {
    public final String originalTo;
    public final String originalFrom;
    public String from;
    public String to;
    public Element element;

    public Field(String from, String to, Element element) {
        this.from = from;
        this.to = to;
        this.originalFrom = from;
        this.originalTo = to;
        this.element = element;
    }

    public void removeDestinationPrefix(String simpleName, String fqcn) {
        this.to = this.removePrefixes(this.to, simpleName, fqcn);
    }

    public void removeSourcePrefix(String simpleName, String fqcn) {
        this.from = this.removePrefixes(this.from, simpleName, fqcn);
    }

    private String removePrefixes(String key, String simpleName, String fqcn) {
        key = key.replace(simpleName + ".", "");
        return key.replace(fqcn + ".", "");
    }

    public boolean hasEmbedded() {
        return this.from.contains(".") || this.to.contains(".");
    }

    public boolean sourceEmbedded() {
        return this.from.contains(".");
    }

    public String[] fromFields() {
        return this.from.split("\\.");
    }

    public boolean hasEmbeddedSourceAndDestination() {
        return this.from.contains(".") && this.to.contains(".");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@Field{ \"");
        sb.append(this.originalTo).append("\"");
        sb.append(", \"").append(this.originalFrom).append("\"");
        sb.append('}');
        return sb.toString();
    }

    public String[] toFields() {
        return this.to.split("\\.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (this.originalFrom != null ? !this.originalFrom.equals(field.originalFrom) : field.originalFrom != null) {
            return false;
        }
        return !(this.originalTo != null ? !this.originalTo.equals(field.originalTo) : field.originalTo != null);
    }

    public int hashCode() {
        int result = this.originalTo != null ? this.originalTo.hashCode() : 0;
        result = 31 * result + (this.originalFrom != null ? this.originalFrom.hashCode() : 0);
        return result;
    }

    public boolean hasOneFieldMatching(Field field) {
        return this.to.equals(field.to) || this.to.equals(field.from) || this.from.equals(field.from);
    }
}

