/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.Fields;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.Field;
import fr.xebia.extras.selma.codegen.FieldMap;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public class FieldsWrapper {
    private MapperGeneratorContext context;
    private Element element;
    private FieldMap fieldsRegistry;
    private FieldMap unusedFields;
    private FieldsWrapper parent = null;

    private FieldsWrapper(MapperGeneratorContext context, Element element) {
        this.context = context;
        this.element = element;
        this.fieldsRegistry = new FieldMap(element);
    }

    public FieldsWrapper(MapperGeneratorContext context, MethodWrapper mapperMethod, FieldsWrapper parent, List<AnnotationWrapper> withCustomFields) {
        this(context, mapperMethod.element());
        if (mapperMethod.hasFields()) {
            this.processFields(context, this.element);
        }
        if (withCustomFields != null && withCustomFields.size() > 0) {
            this.processFieldList(context, withCustomFields);
        }
        this.unusedFields = new FieldMap(this.fieldsRegistry);
        this.parent = parent;
    }

    public FieldsWrapper(MapperGeneratorContext context, TypeElement type, AnnotationWrapper mapper) {
        this(context, type);
        this.processFields(context, type);
        this.processFieldsFromMapper(context, mapper);
        this.unusedFields = new FieldMap(this.fieldsRegistry);
        this.parent = null;
    }

    private void processFieldsFromMapper(MapperGeneratorContext context, AnnotationWrapper mapper) {
        List<AnnotationWrapper> withCustomFields = mapper.getAsAnnotationWrapper("withCustomFields");
        this.processFieldList(context, withCustomFields);
    }

    private void processFields(MapperGeneratorContext context, Element type) {
        AnnotationWrapper fields = AnnotationWrapper.buildFor(context, type, Fields.class);
        if (fields != null) {
            this.processFieldList(context, fields.getAsAnnotationWrapper("value"));
        }
    }

    private void processFieldList(MapperGeneratorContext context, List<AnnotationWrapper> fields) {
        for (AnnotationWrapper field : fields) {
            List<String> fieldPair = field.getAsStrings("value");
            if (fieldPair.size() != 2) {
                context.error(this.element, "Invalid @Field use, @Field should have 2 strings which link one field to another", new Object[0]);
                continue;
            }
            if (fieldPair.get(0).isEmpty() || fieldPair.get(1).isEmpty()) {
                context.error(this.element, "Invalid @Field use, @Field can not have empty string \n--> Fix @Field({\"%s\",\"%s\"})", fieldPair.get(0), fieldPair.get(1));
                continue;
            }
            this.fieldsRegistry.push(fieldPair.get(0).toLowerCase(), fieldPair.get(1).toLowerCase());
        }
    }

    public List<Field> getFieldFor(String field, DeclaredType sourceType, DeclaredType destinationType) {
        String sourceFqcn = sourceType.toString().toLowerCase();
        String sourceSimpleName = sourceType.asElement().getSimpleName().toString().toLowerCase();
        String destinationFqcn = destinationType.toString().toLowerCase();
        String destinationSimpleName = destinationType.asElement().getSimpleName().toString().toLowerCase();
        ArrayList<Field> resParent = new ArrayList<Field>();
        ArrayList<Field> res = new ArrayList<Field>();
        if (this.parent != null) {
            resParent.addAll(this.parent.getFieldFor(field, sourceType, destinationType));
        }
        res.addAll(this.fieldsRegistry.getStartingWith(field));
        res.addAll(this.fieldsRegistry.getStartingWith(sourceFqcn + "." + field));
        res.addAll(this.fieldsRegistry.getStartingWith(sourceSimpleName + "." + field));
        for (Field re : res) {
            this.unusedFields.remove(re.to);
            re.removeDestinationPrefix(destinationFqcn, destinationSimpleName);
            re.removeSourcePrefix(sourceFqcn, sourceSimpleName);
            Iterator parentIterator = resParent.iterator();
            while (parentIterator.hasNext()) {
                Field parentField = (Field)parentIterator.next();
                if (!parentField.hasOneFieldMatching(re)) continue;
                parentIterator.remove();
            }
        }
        res.addAll(resParent);
        return res;
    }

    public void reportUnused() {
        for (Map.Entry<String, String> unusedPair : this.unusedFields.entrySet()) {
            this.context.warn(this.element, "Custom @Field({\"%s\",\"%s\"}) mapping is never used !", unusedPair.getKey(), unusedPair.getValue());
        }
    }
}

