/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.IgnoreFields;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;

public class IgnoreFieldsWrapper {
    private final AnnotationWrapper annotationWrapper;
    private final List<String> fields;
    private final TreeSet<String> unusedFields;
    private final MapperGeneratorContext context;
    private final Element mapperMethod;
    private IgnoreFieldsWrapper parent;

    public IgnoreFieldsWrapper(MapperGeneratorContext context, Element mapperMethod, List<String> ignoreFieldsParam) {
        this.context = context;
        this.mapperMethod = mapperMethod;
        this.annotationWrapper = AnnotationWrapper.buildFor(context, mapperMethod, IgnoreFields.class);
        this.fields = this.annotationWrapper != null ? this.annotationWrapper.getAsStrings("value") : (ignoreFieldsParam != null && ignoreFieldsParam.size() > 0 ? ignoreFieldsParam : Collections.EMPTY_LIST);
        this.unusedFields = new TreeSet<String>(this.fields);
        this.parent = null;
    }

    public IgnoreFieldsWrapper(MapperGeneratorContext context, Element mapperMethod, IgnoreFieldsWrapper parent, List<String> ignoreFieldsParam) {
        this(context, mapperMethod, ignoreFieldsParam);
        this.parent = parent;
    }

    public boolean isIgnoredField(String field, DeclaredType type) {
        boolean res = false;
        String fqcn = type.toString();
        String simpleName = type.asElement().getSimpleName().toString();
        String lastIgnoredField = null;
        Iterator<String> i$ = this.fields.iterator();
        while (i$.hasNext()) {
            String ignoredField;
            lastIgnoredField = ignoredField = i$.next();
            if (ignoredField.equalsIgnoreCase(field)) {
                res = true;
                break;
            }
            if (!ignoredField.contains(".")) continue;
            if ((fqcn + "." + field).equalsIgnoreCase(ignoredField)) {
                res = true;
                break;
            }
            if (!(simpleName + "." + field).equalsIgnoreCase(ignoredField)) continue;
            res = true;
            break;
        }
        if (res) {
            this.unusedFields.remove(lastIgnoredField);
        } else if (this.parent != null) {
            res = this.parent.isIgnoredField(field, type);
        }
        return res;
    }

    public void reportUnusedFields() {
        for (String field : this.unusedFields) {
            this.context.warn(this.mapperMethod, "Ignored field \"%s\" is never used", field);
        }
    }
}

