/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.IoC;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MapperMethodGenerator;
import fr.xebia.extras.selma.codegen.MapperWrapper;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

public class MapperClassGenerator {
    public static final String GENERATED_BY_SELMA = "GENERATED BY S3LM4";
    private final Collection<ExecutableElement> mapperMethods;
    private final String origClasse;
    private final ProcessingEnvironment processingEnv;
    private final MapperGeneratorContext context;
    private final TypeElement element;
    private final MapperWrapper mapper;
    private final DeclaredType declaredType;
    private List<MethodWrapper> methodWrappers;

    public MapperClassGenerator(String classe, Collection<ExecutableElement> executableElements, ProcessingEnvironment processingEnvironment) {
        this.origClasse = classe;
        this.mapperMethods = executableElements;
        this.processingEnv = processingEnvironment;
        this.context = new MapperGeneratorContext(this.processingEnv);
        this.element = this.context.getTypeElement(classe);
        this.declaredType = (DeclaredType)this.element.asType();
        this.mapper = new MapperWrapper(this.context, this.element);
        this.context.setWrapper(this.mapper);
        this.methodWrappers = this.validateTypes();
    }

    private List<MethodWrapper> validateTypes() {
        ArrayList<MethodWrapper> res = new ArrayList<MethodWrapper>();
        for (ExecutableElement mapperMethod : this.mapperMethods) {
            MethodWrapper methodWrapper = new MethodWrapper(mapperMethod, this.declaredType, this.context);
            res.add(methodWrapper);
            this.mapper.buildEnumForMethod(methodWrapper);
            InOutType inOutType = methodWrapper.inOutType();
            if (!inOutType.differs()) continue;
            MappingBuilder builder = MappingBuilder.getBuilderFor(this.context, inOutType);
            if ((inOutType.in().getKind() != TypeKind.DECLARED || inOutType.out().getKind() != TypeKind.DECLARED) && builder == null) {
                this.context.error(mapperMethod, "In type : %s and Out type : %s differs and this kind of conversion is not supported here", inOutType.in(), inOutType.out());
                continue;
            }
            this.context.mappingMethod(methodWrapper.inOutType(), methodWrapper.getSimpleName());
        }
        return res;
    }

    public void build() throws IOException {
        boolean firstMethod = true;
        JavaWriter writer = null;
        JavaFileObject sourceFile = null;
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(this.origClasse);
        String adapterName = type.toString() + "SelmaGeneratedClass";
        for (MethodWrapper mapperMethod : this.methodWrappers) {
            if (firstMethod) {
                String packageName = this.getPackage(mapperMethod.element()).getQualifiedName().toString();
                String strippedTypeName = this.strippedTypeName(type.getQualifiedName().toString(), packageName);
                sourceFile = this.processingEnv.getFiler().createSourceFile(adapterName, type);
                writer = new JavaWriter(sourceFile.openWriter());
                writer.emitSingleLineComment(GENERATED_BY_SELMA, new Object[0]);
                writer.emitPackage(packageName);
                writer.emitEmptyLine();
                if (this.mapper.ioC == IoC.SPRING) {
                    if (this.mapper.ioCServiceName != "") {
                        writer.emitAnnotation("org.springframework.stereotype.Service", (Object)("\"" + this.mapper.ioCServiceName + "\""));
                    } else {
                        writer.emitAnnotation("org.springframework.stereotype.Service");
                    }
                }
                this.openClassBlock(writer, adapterName, strippedTypeName);
                writer.emitEmptyLine();
                firstMethod = false;
            }
            MapperMethodGenerator mapperMethodGenerator = new MapperMethodGenerator(writer, mapperMethod, this.mapper);
            mapperMethodGenerator.build();
            this.mapper.collectMaps(mapperMethodGenerator.maps());
            writer.emitEmptyLine();
        }
        this.buildConstructor(writer, adapterName);
        writer.endType();
        writer.close();
        this.mapper.reportUnused();
    }

    private void openClassBlock(JavaWriter writer, String adapterName, String strippedTypeName) throws IOException {
        String[] interfaceName = new String[]{strippedTypeName};
        String className = strippedTypeName;
        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC);
        if (this.mapper.isAbstractClass()) {
            interfaceName = new String[]{};
        } else {
            className = null;
        }
        if (this.mapper.isFinalMappers()) {
            modifiers = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL);
        }
        writer.beginType(adapterName, "class", modifiers, className, interfaceName);
    }

    private void buildConstructor(JavaWriter writer, String adapterName) throws IOException {
        this.mapper.emitSourceFields(writer);
        this.mapper.emitCustomMappersFields(writer, false);
        this.mapper.emitFactoryFields(writer, false);
        writer.emitEmptyLine();
        writer.emitJavadoc("Single constructor", new Object[0]);
        writer.beginMethod(null, adapterName, EnumSet.of(Modifier.PUBLIC), this.mapper.sourceConstructorArgs());
        this.mapper.emitSourceAssigns(writer);
        this.mapper.emitCustomMappersFields(writer, true);
        this.mapper.emitFactoryFields(writer, true);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    public PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    public String strippedTypeName(String type, String packageName) {
        return type.substring(packageName.isEmpty() ? 0 : packageName.length() + 1);
    }
}

