/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.CollectionMappingStrategy;
import fr.xebia.extras.selma.IgnoreMissing;
import fr.xebia.extras.selma.IoC;
import fr.xebia.extras.selma.Mapper;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.BeanWrapper;
import fr.xebia.extras.selma.codegen.CustomMapperWrapper;
import fr.xebia.extras.selma.codegen.EnumMappersWrapper;
import fr.xebia.extras.selma.codegen.FactoryWrapper;
import fr.xebia.extras.selma.codegen.FieldsWrapper;
import fr.xebia.extras.selma.codegen.IgnoreFieldsWrapper;
import fr.xebia.extras.selma.codegen.ImmutableTypesWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MappingRegistry;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.MapsWrapper;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import fr.xebia.extras.selma.codegen.SourceConfiguration;
import fr.xebia.extras.selma.codegen.SourceWrapper;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class MapperWrapper {
    public static final String WITH_IGNORE_FIELDS = "withIgnoreFields";
    public static final String WITH_ENUMS = "withEnums";
    public static final String WITH_IGNORE_MISSING = "withIgnoreMissing";
    public static final String WITH_IOC = "withIoC";
    public static final String WITH_COLLECTION_STRATEGY = "withCollectionStrategy";
    public static final String WITH_IOC_SERVICE_NAME = "withIoCServiceName";
    public static final String WITH_CYCLIC_MAPPING = "withCyclicMapping";
    public static final String WITH_IGNORE_NULL_VALUE = "withIgnoreNullValue";
    final IoC ioC;
    final String ioCServiceName;
    private final FieldsWrapper fields;
    private final SourceConfiguration configuration;
    private final IgnoreFieldsWrapper ignoreFieldsWrapper;
    private final MappingRegistry mappingRegistry;
    private final CustomMapperWrapper customMappers;
    private final ImmutableTypesWrapper immutablesMapper;
    private final AnnotationWrapper mapper;
    private final EnumMappersWrapper enumMappers;
    private final MapperGeneratorContext context;
    private final TypeElement mapperInterface;
    private final SourceWrapper source;
    private final IgnoreMissing ignoreMissing;
    private final CollectionMappingStrategy collectionMappingStrategy;
    private final boolean abstractClass;
    private final FactoryWrapper factory;
    private final boolean useCyclicMapping;
    private boolean ignoreNullValue;

    public MapperWrapper(MapperGeneratorContext context, TypeElement mapperInterface) {
        this.context = context;
        this.mapperInterface = mapperInterface;
        this.mappingRegistry = new MappingRegistry(context);
        this.mapper = AnnotationWrapper.buildFor(context, mapperInterface, Mapper.class);
        List<String> ignoreFieldsParam = this.mapper.getAsStrings(WITH_IGNORE_FIELDS);
        this.ignoreFieldsWrapper = new IgnoreFieldsWrapper(context, mapperInterface, ignoreFieldsParam);
        this.configuration = SourceConfiguration.buildFrom(this.mapper, this.ignoreFieldsWrapper);
        IgnoreMissing missing = IgnoreMissing.valueOf((String)this.mapper.getAsString(WITH_IGNORE_MISSING));
        this.ignoreMissing = missing == IgnoreMissing.DEFAULT ? (this.configuration.isIgnoreMissingProperties() ? IgnoreMissing.ALL : IgnoreMissing.NONE) : missing;
        this.ioC = IoC.valueOf((String)this.mapper.getAsString(WITH_IOC));
        this.ioCServiceName = this.mapper.getAsString(WITH_IOC_SERVICE_NAME);
        this.collectionMappingStrategy = CollectionMappingStrategy.valueOf((String)this.mapper.getAsString(WITH_COLLECTION_STRATEGY));
        this.fields = new FieldsWrapper(context, mapperInterface, this.mapper);
        this.mappingRegistry.fields(this.fields);
        this.ignoreNullValue = this.mapper.getAsBoolean(WITH_IGNORE_NULL_VALUE);
        context.setIgnoreNullValue(this.ignoreNullValue);
        this.customMappers = new CustomMapperWrapper(this.mapper, context);
        this.mappingRegistry.customMappers(this.customMappers);
        if (mapperInterface.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.customMappers.addMappersElementMethods(mapperInterface);
        }
        this.enumMappers = new EnumMappersWrapper(this.withEnums(), context, (Element)mapperInterface);
        this.mappingRegistry.enumMappers(this.enumMappers);
        this.immutablesMapper = new ImmutableTypesWrapper(this.mapper, context);
        this.mappingRegistry.immutableTypes(this.immutablesMapper);
        this.source = new SourceWrapper(this.mapper, context);
        this.factory = new FactoryWrapper(this.mapper, context);
        this.abstractClass = mapperInterface.getModifiers().contains((Object)Modifier.ABSTRACT) && mapperInterface.getKind() == ElementKind.CLASS;
        this.useCyclicMapping = this.mapper.getAsBoolean(WITH_CYCLIC_MAPPING);
    }

    public List<AnnotationWrapper> withEnums() {
        return this.mapper.getAsAnnotationWrapper(WITH_ENUMS);
    }

    public void buildEnumForMethod(MethodWrapper methodWrapper) {
        this.enumMappers.buildForMethod(methodWrapper);
    }

    public boolean isFinalMappers() {
        return this.configuration.isFinalMappers();
    }

    public MappingRegistry registry() {
        return this.mappingRegistry;
    }

    public SourceConfiguration configuration() {
        return this.configuration;
    }

    public void reportUnused() {
        this.customMappers.reportUnused();
        this.ignoreFieldsWrapper.reportUnusedFields();
        this.fields.reportUnused();
        this.enumMappers.reportUnused();
        this.immutablesMapper.reportUnused();
        this.factory.reportUnused();
    }

    public void emitCustomMappersFields(JavaWriter writer, boolean assign) throws IOException {
        this.customMappers.emitCustomMappersFields(writer, assign);
    }

    public MapperGeneratorContext context() {
        return this.context;
    }

    public IgnoreFieldsWrapper ignoredFields() {
        return this.ignoreFieldsWrapper;
    }

    public FieldsWrapper fields() {
        return this.fields;
    }

    public boolean isIgnoreMissingProperties() {
        return this.configuration.isIgnoreMissingProperties();
    }

    public CustomMapperWrapper customMappers() {
        return this.customMappers;
    }

    public void collectMaps(MapsWrapper maps) {
        this.customMappers.addFields(maps.customMapperFields());
    }

    public void emitSourceFields(JavaWriter writer) throws IOException {
        this.source.emitFields(writer);
    }

    public String[] sourceConstructorArgs() {
        return this.source.sourceConstructorArgs();
    }

    public void emitSourceAssigns(JavaWriter writer) throws IOException {
        this.source.emitAssigns(writer);
    }

    public IgnoreMissing ignoreMissing() {
        return this.ignoreMissing;
    }

    public boolean allowCollectionGetter() {
        return this.collectionMappingStrategy == CollectionMappingStrategy.ALLOW_GETTER;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void emitFactoryFields(JavaWriter writer, boolean assign) throws IOException {
        this.factory.emitFactoryFields(writer, assign);
    }

    public MappingSourceNode generateNewInstanceSourceNodes(InOutType inOutType, BeanWrapper outBeanWrapper) {
        MappingSourceNode res = this.factory.generateNewInstanceSourceNodes(inOutType, outBeanWrapper);
        if (res == null) {
            res = MappingSourceNode.instantiateOut(this.useCyclicMapping, inOutType, outBeanWrapper.hasMatchingSourcesConstructor() ? this.context.newParams() : "");
        }
        return res;
    }

    public boolean hasFactory(TypeMirror typeMirror) {
        return this.factory.hasFactory(typeMirror);
    }

    public boolean isUseCyclicMapping() {
        return this.useCyclicMapping;
    }
}

