/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.InstanceCache;
import fr.xebia.extras.selma.SimpleInstanceCache;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public abstract class MappingSourceNode {
    MappingSourceNode body;
    MappingSourceNode child;

    public static final MappingSourceNode blank() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
            }
        };
    }

    public static MappingSourceNode mapMethod(final MapperGeneratorContext context, final InOutType inOutType, final String name, final boolean override, final boolean isFinal) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(inOutType.in().toString());
                parameters.add("in");
                if (inOutType.isOutPutAsParam()) {
                    parameters.add(inOutType.out().toString());
                    parameters.add("out");
                }
                if (override) {
                    writer.emitAnnotation(Override.class);
                }
                if (context.getWrapper().isUseCyclicMapping()) {
                    writer.emitJavadoc("Mapping method overridden by Selma", new Object[0]);
                    writer.beginMethod(inOutType.out().toString(), name, isFinal ? EnumSet.of(Modifier.PUBLIC, Modifier.FINAL) : EnumSet.of(Modifier.PUBLIC), parameters, null);
                    if (inOutType.isOutPutAsParam()) {
                        writer.emitStatement("return %s(in, out, new %s())", new Object[]{name, SimpleInstanceCache.class.getName()});
                    } else {
                        writer.emitStatement("return %s(in, new %s())", new Object[]{name, SimpleInstanceCache.class.getName()});
                    }
                    writer.endMethod();
                    writer.emitEmptyLine();
                    parameters.add(InstanceCache.class.getName());
                    parameters.add("instanceCache");
                }
                writer.beginMethod(inOutType.out().toString(), name, isFinal ? EnumSet.of(Modifier.PUBLIC, Modifier.FINAL) : EnumSet.of(Modifier.PUBLIC), parameters, null);
                this.writeBody(writer);
                writer.emitStatement("return out", new Object[0]);
                writer.endMethod();
                writer.emitEmptyLine();
            }
        };
    }

    public static MappingSourceNode controlInCache(final String field, final String outType) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s object = %s.get(%s)", new Object[]{outType, "instanceCache", field});
                writer.beginControlFlow(String.format("if (object != null)", new Object[0]), new Object[0]);
                writer.emitStatement("return object", new Object[0]);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode pushInCache() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s.push()", new Object[]{"instanceCache"});
            }
        };
    }

    public static MappingSourceNode popFromCache() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s.pop()", new Object[]{"instanceCache"});
            }
        };
    }

    public static MappingSourceNode controlNotNull(final String field, final boolean outPutAsParam) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("if (%s != null)", field), new Object[0]);
                this.writeBody(writer);
                if (outPutAsParam) {
                    writer.nextControlFlow("else", new Object[0]);
                    writer.emitStatement("out = null", new Object[0]);
                }
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode tryBlock() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow("try", new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode finallyBlock() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow("finally", new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode controlNull(final String field) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("if (%s == null)", field), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode controlNullElse() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow("else", new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode set(final String outField, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s(%s)", new Object[]{outField, inField});
            }
        };
    }

    public static MappingSourceNode assign(final String outField, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s = %s", new Object[]{outField, inField});
            }
        };
    }

    public static MappingSourceNode assignOutPrime() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("out = in", new Object[0]);
            }
        };
    }

    public static MappingSourceNode assignOutToString() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("out = in + \"\"", new Object[0]);
            }
        };
    }

    public static MappingSourceNode declareOut(final TypeMirror outType) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s out %s", new Object[]{outType, outType.getKind().isPrimitive() ? "= fr.xebia.extras.selma.SelmaConstants.DEFAULT_" + (Object)((Object)outType.getKind()) : "= null"});
            }
        };
    }

    public static MappingSourceNode notSupported(final String message) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitJavadoc("Throw UnsupportedOperationException because we failed to generate the mapping code:\n" + message, new Object[0]);
                writer.emitStatement("throw new UnsupportedOperationException(\"%s\")", new Object[]{message.replace("\n", " ")});
            }
        };
    }

    public static MappingSourceNode mapArray(final String indexVar, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (int %s = 0 ; %s < %s.length; %s++)", indexVar, indexVar, inField, indexVar), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapArrayBis(final String indexVar, final String totalCount) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (int %s = 0 ; %s < %s; %s++)", indexVar, indexVar, totalCount, indexVar), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapCollection(final String itemVar, final String in, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (%s %s : %s)", in, itemVar, inField), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapMap(final String itemVar, final String keyType, final String valueType, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow("for (java.util.Map.Entry<%s,%s> %s : %s.entrySet())", new Object[]{keyType, valueType, itemVar, inField});
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapEnumBlock(final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("switch (%s)", inField), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapEnumCase(final String value) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("case %s : ", value), new Object[0]);
                this.writeBody(writer);
                writer.emitStatement("break", new Object[0]);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapDefaultCase() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(" default : ", new Object[0]);
                this.writeBody(writer);
                writer.emitStatement("break", new Object[0]);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode statement(final String statement) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement(statement, new Object[0]);
            }
        };
    }

    public static MappingSourceNode instantiateOut(final boolean useCyclicMapping, final InOutType inOutType, final String params) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                if (inOutType.isOutPutAsParam()) {
                    writer.beginControlFlow("if (out == null)", new Object[0]);
                    this.instantiate(inOutType, params, writer);
                    writer.endControlFlow();
                } else {
                    this.instantiate(inOutType, params, writer);
                }
            }

            private void instantiate(InOutType inOutType2, String params2, JavaWriter writer) throws IOException {
                writer.emitStatement("%s = new %s(%s)", new Object[]{"out", inOutType2.out().toString(), params2});
                if (useCyclicMapping) {
                    writer.emitStatement("%s.put(%s, %s)", new Object[]{"instanceCache", "in", "out"});
                }
            }
        };
    }

    public static MappingSourceNode callStaticFactoryOut(final InOutType inOutType, final String factoryCall) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                if (inOutType.isOutPutAsParam()) {
                    writer.beginControlFlow("if (out == null)", new Object[0]);
                    writer.emitStatement("out = %s()", new Object[]{factoryCall});
                    writer.endControlFlow();
                } else {
                    writer.emitStatement("out = %s()", new Object[]{factoryCall});
                }
            }
        };
    }

    public static MappingSourceNode callGenericFactoryOut(final InOutType inOutType, final String factoryCall) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                if (inOutType.isOutPutAsParam()) {
                    writer.beginControlFlow("if (out == null)", new Object[0]);
                    writer.emitStatement("out = %s(%s.class)", new Object[]{factoryCall, inOutType.out()});
                    writer.endControlFlow();
                } else {
                    writer.emitStatement("out = %s(%s.class)", new Object[]{factoryCall, inOutType.out()});
                }
            }
        };
    }

    public static MappingSourceNode put(final String outCollection, final String itemVar) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s.put(%s.getKey(), %s.getValue())", new Object[]{outCollection, itemVar, itemVar});
            }
        };
    }

    public static MappingSourceNode arrayCopy(final String inGetterFor, final String outGetterFor) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("System.arraycopy(%s, 0, %s, 0, %s.length)", new Object[]{inGetterFor, outGetterFor, inGetterFor});
            }
        };
    }

    abstract void writeNode(JavaWriter var1) throws IOException;

    public void write(JavaWriter writer) throws IOException {
        this.writeNode(writer);
        if (this.child != null) {
            this.child.write(writer);
        }
    }

    public void writeBody(JavaWriter writer) throws IOException {
        if (this.body != null) {
            this.body.write(writer);
        }
    }

    public MappingSourceNode lastChild() {
        MappingSourceNode ptr = this;
        while (ptr.child != null) {
            ptr = ptr.child;
        }
        return ptr;
    }

    public MappingSourceNode body(MappingSourceNode body) {
        if (this.body != null) {
            return this.child(body);
        }
        this.body = body;
        return body;
    }

    public MappingSourceNode child(MappingSourceNode child) {
        this.child = child;
        return child;
    }
}

