/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.EnumMapper;
import fr.xebia.extras.selma.Fields;
import fr.xebia.extras.selma.IgnoreFields;
import fr.xebia.extras.selma.Mapper;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class MethodWrapper {
    private static final String GETTER_FORMAT = "(get|is)(.*)";
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is)(.*)");
    private static final String SETTER_FORMAT = "set(.*)";
    private static final Pattern SETTER_PATTERN = Pattern.compile("set(.*)");
    private final ExecutableElement method;
    private final ExecutableType executableType;
    private final MapperGeneratorContext context;
    boolean ignoreMissingProperties = false;
    private DeclaredType parentType;
    private String fieldName;

    public MethodWrapper(ExecutableElement method, DeclaredType declaredType, MapperGeneratorContext context) {
        this.method = method;
        this.parentType = declaredType;
        this.context = context;
        this.executableType = (ExecutableType)context.type.asMemberOf(this.parentType, method);
        AnnotationWrapper annotationWrapper = AnnotationWrapper.buildFor(context, method, Mapper.class);
        if (annotationWrapper != null) {
            this.ignoreMissingProperties = annotationWrapper.getAsBoolean("ignoreMissingProperties");
        }
    }

    public TypeMirror firstParameterType() {
        if (this.method.getParameters().size() > 0) {
            return this.executableType.getParameterTypes().get(0);
        }
        return null;
    }

    public TypeMirror returnType() {
        return this.executableType.getReturnType();
    }

    public String getSimpleName() {
        return this.method.getSimpleName().toString();
    }

    public InOutType inOutType() {
        return new InOutType(this.firstParameterType(), this.returnType(), this.parameterCount() == 2);
    }

    public InOutType inOutArgs() {
        return new InOutType(this.firstParameterType(), this.secondParameterType(), this.parameterCount() == 2);
    }

    private TypeMirror secondParameterType() {
        if (this.method.getParameters().size() > 1) {
            return this.executableType.getParameterTypes().get(1);
        }
        return null;
    }

    public ExecutableElement element() {
        return this.method;
    }

    public boolean hasOneParameter() {
        return this.method.getParameters().size() == 1;
    }

    public int parameterCount() {
        return this.method.getParameters().size();
    }

    public boolean hasReturnType() {
        return this.method.getReturnType() != null && this.method.getReturnType().getKind() != TypeKind.VOID;
    }

    public boolean isGetter() {
        Matcher getterMatcher;
        boolean res = false;
        if (this.hasNoParameter() && this.method.getReturnType().getKind() != TypeKind.VOID && this.method.getModifiers().contains((Object)Modifier.PUBLIC) && !this.method.getModifiers().contains((Object)Modifier.ABSTRACT) && !this.method.getModifiers().contains((Object)Modifier.STATIC) && (res = (getterMatcher = GETTER_PATTERN.matcher(this.method.getSimpleName())).matches())) {
            this.fieldName = getterMatcher.group(2);
        }
        return res;
    }

    public boolean isSetter() {
        boolean res = false;
        if (this.method.getParameters().size() == 1 && this.method.getModifiers().contains((Object)Modifier.PUBLIC) && !this.method.getModifiers().contains((Object)Modifier.ABSTRACT) && !this.method.getModifiers().contains((Object)Modifier.STATIC)) {
            Matcher setterMatcher;
            boolean validReturnType;
            boolean bl = validReturnType = this.method.getReturnType().getKind() == TypeKind.VOID;
            if (!validReturnType) {
                ExecutableType memberMethod = (ExecutableType)this.context.type.asMemberOf(this.parentType, this.method);
                TypeMirror memberReturnType = memberMethod.getReturnType();
                if (memberReturnType.getKind() == TypeKind.TYPEVAR) {
                    memberReturnType = ((TypeVariable)memberReturnType).getUpperBound();
                }
                validReturnType = this.context.type.isSameType(memberReturnType, this.parentType);
            }
            if (validReturnType && (res = (setterMatcher = SETTER_PATTERN.matcher(this.method.getSimpleName())).matches())) {
                this.fieldName = setterMatcher.group(1);
            }
        }
        return res;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean hasAnnotation(String annotation) {
        boolean res = false;
        for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation)) continue;
            res = true;
            break;
        }
        return res;
    }

    public boolean hasIgnoreFields() {
        return this.hasAnnotation(IgnoreFields.class.getCanonicalName());
    }

    public boolean hasEnumMapper() {
        return this.hasAnnotation(EnumMapper.class.getCanonicalName());
    }

    public boolean isCustomMapper() {
        return this.hasReturnType() && this.hasOneParameter() || this.hasReturnType() && this.hasTwoParameter() && this.secondParamIsReturnType();
    }

    private boolean secondParamIsReturnType() {
        boolean res = false;
        TypeMirror secondParameterType = this.secondParameterType();
        TypeMirror returnType = this.returnType();
        res = this.context.type.isSameType(secondParameterType, returnType);
        return res;
    }

    public boolean isMappingInterceptor() {
        return !this.hasReturnType() && this.hasTwoParameter();
    }

    private boolean hasTwoParameter() {
        return this.method.getParameters().size() == 2;
    }

    public boolean hasFields() {
        return this.hasAnnotation(Fields.class.getCanonicalName());
    }

    public boolean isAbstract() {
        return this.method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isFactory() {
        boolean res = false;
        if (this.hasReturnType()) {
            if (this.hasNoParameter()) {
                res = true;
            } else if (this.hasOneParameter()) {
                VariableElement variableElement = this.method.getParameters().get(0);
                TypeMirror typeMirror = variableElement.asType();
                typeMirror.getKind();
                res = true;
            }
        }
        return this.hasReturnType() && (this.hasOneParameter() || this.hasNoParameter());
    }

    private boolean hasNoParameter() {
        return this.method.getParameters().size() == 0;
    }

    public boolean hasTypeParameter() {
        return !this.method.getTypeParameters().isEmpty();
    }
}

