/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class AnnotationWrapper {
    private final AnnotationMirror annotationMirror;
    private final Element annotatedElement;
    private final HashMap<String, AnnotationValue> map;
    private final MapperGeneratorContext context;

    public AnnotationWrapper(MapperGeneratorContext context, AnnotationMirror annotationMirror, Element annotatedElement) {
        this.annotationMirror = annotationMirror;
        this.annotatedElement = annotatedElement;
        this.map = new HashMap();
        this.context = context;
        for (ExecutableElement executableElement : context.elements.getElementValuesWithDefaults(annotationMirror).keySet()) {
            this.map.put(executableElement.getSimpleName().toString(), context.elements.getElementValuesWithDefaults(annotationMirror).get(executableElement));
        }
    }

    public static AnnotationWrapper buildFor(MapperGeneratorContext context, Element method, Class<?> annot) {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : method.getAnnotationMirrors()) {
            if (!annotationMirror2.getAnnotationType().toString().equals(annot.getCanonicalName())) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        if (annotationMirror != null) {
            return new AnnotationWrapper(context, annotationMirror, method);
        }
        return null;
    }

    public List<String> getAsStrings(String parameterName) {
        ArrayList<String> res = new ArrayList<String>();
        AnnotationValue myValue = this.map.get(parameterName);
        if (myValue.getValue() instanceof List) {
            List values = (List)myValue.getValue();
            for (AnnotationValue value : values) {
                if (value.getValue() instanceof String) {
                    res.add((String)value.getValue());
                    continue;
                }
                res.add(value.toString());
            }
        } else {
            res.add(myValue.getValue().toString());
        }
        return res;
    }

    public List<AnnotationWrapper> getAsAnnotationWrapper(String parameterName) {
        ArrayList<AnnotationWrapper> res = new ArrayList<AnnotationWrapper>();
        AnnotationValue myValue = this.map.get(parameterName);
        if (myValue.getValue() instanceof List) {
            List values = (List)myValue.getValue();
            for (AnnotationValue value : values) {
                if (!(value.getValue() instanceof AnnotationMirror)) continue;
                res.add(new AnnotationWrapper(this.context, (AnnotationMirror)value.getValue(), this.annotatedElement));
            }
        }
        return res;
    }

    public boolean getAsBoolean(String ignoreMissingProperties) {
        return (Boolean)this.map.get(ignoreMissingProperties).getValue();
    }

    public TypeMirror getAsTypeMirror(String parameter) {
        String classe = this.map.get(parameter).getValue().toString();
        TypeElement element = this.context.elements.getTypeElement(classe.replace(".class", ""));
        return element.asType();
    }

    public String getAsString(String parameter) {
        AnnotationValue parameterValue = this.map.get(parameter);
        if (parameterValue != null) {
            return parameterValue.getValue().toString();
        }
        return null;
    }

    public <T> T getAs(String parameter) {
        return (T)this.map.get(parameter).getValue();
    }

    public Element asElement() {
        return this.annotationMirror.getAnnotationType().asElement();
    }

    public Element getAnnotatedElement() {
        return this.annotatedElement;
    }

    public String toString() {
        return this.annotationMirror.toString();
    }
}

