/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.EnumMapper;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class EnumMappersWrapper {
    public static final String DEFAULT_ENUM = "fr.xebia.extras.selma.EnumMapper";
    private final MapperGeneratorContext context;
    private final Element reportElement;
    private final Map<InOutType, MappingBuilder> registryMap;
    private final HashMap<InOutType, AnnotationWrapper> unusedEnumMappers;
    private EnumMappersWrapper parent = null;

    public EnumMappersWrapper(List<AnnotationWrapper> annotationWrappers, MapperGeneratorContext context, Element reportElement) {
        this.context = context;
        this.reportElement = reportElement;
        this.unusedEnumMappers = new HashMap();
        this.registryMap = new HashMap<InOutType, MappingBuilder>();
        if (annotationWrappers != null) {
            for (AnnotationWrapper enumMapper : annotationWrappers) {
                this.buildEnumMapper(enumMapper);
            }
        }
    }

    public EnumMappersWrapper(EnumMappersWrapper parent, List<AnnotationWrapper> enums, Element reportElement) {
        this(enums, parent.context, reportElement);
        this.parent = parent;
    }

    private void buildEnumMapper(AnnotationWrapper enumMapper) {
        InOutType inOutType = new InOutType(enumMapper.getAsTypeMirror("from"), enumMapper.getAsTypeMirror("to"), false);
        this.buildEnumMapperForInOutType(enumMapper, inOutType);
    }

    private void buildEnumMapperForInOutType(AnnotationWrapper enumMapper, InOutType inOutType) {
        String defaultValue = enumMapper.getAsString("defaultValue");
        if (!inOutType.areEnums()) {
            this.context.error(enumMapper.asElement(), "Invalid type given in @EnumMapper one of from=%s and to=%s is not an Enum.\\n You should only use enum types here", inOutType.in(), inOutType.out());
        } else if (inOutType.in().toString().contains(DEFAULT_ENUM) || inOutType.out().toString().contains(DEFAULT_ENUM)) {
            this.context.error(enumMapper.asElement(), "EnumMapper miss use: from and to are mandatory in @EnumMapper when not used on a method that maps enumerations.\\n You should define from and to for this EnumMapper.", new Object[0]);
        } else if (!defaultValue.isEmpty() && !MappingBuilder.collectEnumValues(inOutType.outAsTypeElement()).contains(defaultValue)) {
            this.context.error(this.reportElement, "Invalid default value for @EnumMapper(from=%s.class, to=%s.class, default=\"%s\") %s.%s does not exist", inOutType.in(), inOutType.out(), defaultValue, inOutType.out(), defaultValue);
        } else {
            MappingBuilder res = MappingBuilder.newCustomEnumMapper(inOutType, defaultValue);
            this.unusedEnumMappers.put(inOutType, enumMapper);
            this.registryMap.put(inOutType, res);
            this.registryMap.put(new InOutType(inOutType, true), res);
        }
    }

    public void buildForMethod(MethodWrapper methodWrapper) {
        if (methodWrapper.hasEnumMapper()) {
            TypeMirror enumOut = methodWrapper.returnType();
            TypeMirror enumIn = methodWrapper.firstParameterType();
            InOutType inOutType = new InOutType(enumIn, enumOut, false);
            AnnotationWrapper enumMapper = AnnotationWrapper.buildFor(this.context, methodWrapper.element(), EnumMapper.class);
            if (!inOutType.areEnums()) {
                this.buildEnumMapper(enumMapper);
            } else {
                this.buildEnumMapperForInOutType(enumMapper, inOutType);
            }
        }
    }

    public MappingBuilder get(InOutType inOutType) {
        MappingBuilder res = this.registryMap.get(inOutType);
        if (res != null) {
            this.unusedEnumMappers.remove(inOutType);
        } else if (this.parent != null) {
            res = this.parent.get(inOutType);
        }
        return res;
    }

    public void reportUnused() {
        for (Map.Entry<InOutType, AnnotationWrapper> entry : this.unusedEnumMappers.entrySet()) {
            this.context.warn(entry.getValue().getAnnotatedElement(), "@EnumMapper(from=%s, to=%s) is never used", entry.getKey().in(), entry.getKey().out());
        }
    }
}

