/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.IgnoreFieldsWrapper;
import java.util.Collections;
import java.util.List;

public class SourceConfiguration {
    private final IgnoreFieldsWrapper ignoredFields;
    private boolean ignoreMissingProperties;
    private boolean ignoreNotSupported;
    private List<String> sourceClass;
    private boolean finalMappers;

    private SourceConfiguration(IgnoreFieldsWrapper ignoreFields) {
        this.ignoredFields = ignoreFields;
    }

    public static SourceConfiguration buildFrom(AnnotationWrapper mapper, IgnoreFieldsWrapper ignoreFields) {
        SourceConfiguration res = new SourceConfiguration(ignoreFields);
        res.ignoreMissingProperties(mapper.getAsBoolean("ignoreMissingProperties"));
        res.ignoreNotSupported(mapper.getAsBoolean("ignoreNotSupported"));
        res.finalMappers(mapper.getAsBoolean("withFinalMappers"));
        res.sourceClass(mapper.getAsStrings("withSources"));
        return res;
    }

    private void finalMappers(boolean finalMappers) {
        this.finalMappers = finalMappers;
    }

    public boolean isFinalMappers() {
        return this.finalMappers;
    }

    private void sourceClass(List<String> source) {
        this.sourceClass = source;
    }

    private SourceConfiguration ignoreNotSupported(boolean b) {
        this.ignoreNotSupported = b;
        return this;
    }

    private SourceConfiguration ignoreMissingProperties(boolean b) {
        this.ignoreMissingProperties = b;
        return this;
    }

    public boolean isIgnoreMissingProperties() {
        return this.ignoreMissingProperties;
    }

    public boolean isIgnoreNotSupported() {
        return this.ignoreNotSupported;
    }

    public IgnoreFieldsWrapper ignoredFields() {
        return this.ignoredFields;
    }

    public List<String> getSourceClass() {
        return this.sourceClass != null ? this.sourceClass : Collections.emptyList();
    }
}

