/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ServletContextAware;

public class ServletContextAwareMBeanServerFactory
implements FactoryBean<MBeanServer>,
ServletContextAware,
InitializingBean {
    protected MBeanServer instance;
    protected final Logger logger = LoggerFactory.getLogger(ServletContextAwareMBeanServerFactory.class);
    protected Map<String, String> objectNameExtraAttributes = new HashMap<String, String>();
    protected MBeanServer server;
    protected ServletContext servletContext;

    public void afterPropertiesSet() throws Exception {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        Assert.notNull((Object)this.servletContext, (String)"servletContext can NOT be null");
        this.objectNameExtraAttributes.put("path", this.servletContext.getContextPath());
        if ("org.apache.catalina.core.ApplicationContextFacade".equals(this.servletContext.getClass().getName())) {
            Field applicationContextFacadeContextField = Class.forName("org.apache.catalina.core.ApplicationContextFacade").getDeclaredField("context");
            applicationContextFacadeContextField.setAccessible(true);
            Field applicationContextContextField = Class.forName("org.apache.catalina.core.ApplicationContext").getDeclaredField("context");
            applicationContextContextField.setAccessible(true);
            Field standardContextHostNameField = Class.forName("org.apache.catalina.core.StandardContext").getDeclaredField("hostName");
            standardContextHostNameField.setAccessible(true);
            Object applicationContext = applicationContextFacadeContextField.get(this.servletContext);
            Object standardContext = applicationContextContextField.get(applicationContext);
            String hostName = (String)standardContextHostNameField.get(standardContext);
            this.objectNameExtraAttributes.put("host", hostName);
        }
        this.logger.trace("Extra objectname attributes : {}" + this.objectNameExtraAttributes);
    }

    public MBeanServer getObject() throws Exception {
        if (this.instance == null) {
            InvocationHandler invocationHandler = new InvocationHandler(){

                protected ObjectName addExtraAttributesToObjectName(ObjectName objectName) throws MalformedObjectNameException {
                    Hashtable<String, String> table = new Hashtable<String, String>(objectName.getKeyPropertyList());
                    table.putAll(ServletContextAwareMBeanServerFactory.this.objectNameExtraAttributes);
                    ObjectName result = ObjectName.getInstance(objectName.getDomain(), table);
                    ServletContextAwareMBeanServerFactory.this.logger.trace("addExtraAttributesToObjectName({}): {}", (Object)objectName, (Object)result);
                    return result;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object[] modifiedArgs = (Object[])args.clone();
                    int i = 0;
                    while (i < modifiedArgs.length) {
                        Object arg = modifiedArgs[i];
                        if (arg instanceof ObjectName) {
                            ObjectName objectName = (ObjectName)arg;
                            modifiedArgs[i] = this.addExtraAttributesToObjectName(objectName);
                        }
                        ++i;
                    }
                    if (ServletContextAwareMBeanServerFactory.this.logger.isDebugEnabled()) {
                        ServletContextAwareMBeanServerFactory.this.logger.debug(method + " : " + Arrays.asList(modifiedArgs));
                    }
                    try {
                        return method.invoke((Object)ServletContextAwareMBeanServerFactory.this.server, modifiedArgs);
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getCause();
                    }
                }
            };
            this.instance = (MBeanServer)Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), new Class[]{MBeanServer.class}, invocationHandler);
        }
        return this.instance;
    }

    public Class<? extends MBeanServer> getObjectType() {
        return MBeanServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Deprecated
    public void setMbeanServer(MBeanServer mbeanServer) {
        this.server = mbeanServer;
    }

    public void setObjectNameExtraAttributes(Map<String, String> objectNameExtraAttributes) {
        this.objectNameExtraAttributes = objectNameExtraAttributes;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

