/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.config;

import fr.xebia.springframework.jdbc.ManagedBasicDataSource;
import java.util.Collection;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ManagedBasicDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ManagedBasicDataSource.class);
        builder.setRole(0);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        this.fillBuilderWithAttributeIfExists(builder, element, "accessToUnderlyingConnectionAllowed", "access-to-underlying-connection-allowed", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "connectionInitSqls", "connection-init-sqls", Collection.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "connectionProperties", "connection-properties", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "defaultAutoCommit", "default-auto-commit", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "defaultCatalog", "default-catalog", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "defaultReadOnly", "default-read-only", Boolean.TYPE, parserContext);
        Element defaultTransactionIsolationElement = DomUtils.getChildElementByTagName((Element)element, (String)"default-transaction-isolation");
        if (defaultTransactionIsolationElement != null) {
            int defaultTransactionIsolation;
            String value = defaultTransactionIsolationElement.getAttribute("value");
            if ("NONE".equals(value)) {
                defaultTransactionIsolation = 0;
            } else if ("READ_UNCOMMITTED".equals(value)) {
                defaultTransactionIsolation = 1;
            } else if ("READ_COMMITTED".equals(value)) {
                defaultTransactionIsolation = 2;
            } else if ("REPEATABLE_READ".equals(value)) {
                defaultTransactionIsolation = 4;
            } else if ("SERIALIZABLE".equals(value)) {
                defaultTransactionIsolation = 8;
            } else {
                String msg = "Invalid value for '<default-transaction-isolation' value=\"" + value + "\" />'";
                parserContext.getReaderContext().fatal(msg, (Object)defaultTransactionIsolationElement);
                throw new IllegalStateException(msg);
            }
            builder.addPropertyValue("defaultTransactionIsolation", (Object)defaultTransactionIsolation);
        }
        this.fillBuilderWithAttributeIfExists(builder, element, "driverClassName", "driver-class-name", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "initialSize", "initial-size", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "logAbandoned", "log-abandoned", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "maxActive", "max-active", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "maxIdle", "max-idle", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "maxOpenPreparedStatements", "max-open-prepared-statements", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "maxWait", "max-wait", Long.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "minEvictableIdleTimeMillis", "min-evictable-idle-time-millis", Long.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "minIdle", "min-idle", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "numTestsPerEvictionRun", "num-tests-per-eviction-run", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "password", "password", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "poolPreparedStatements", "pool-prepared-statements", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "removeAbandoned", "remove-abandoned", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "removeAbandonedTimeout", "remove-abandoned-timeout", Integer.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "testOnBorrow", "test-on-borrow", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "testOnReturn", "test-on-return", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "testWhileIdle", "test-while-idle", Boolean.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "timeBetweenEvictionRunsMillis", "time-between-eviction-runs-millis", Long.TYPE, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "url", "url", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "username", "username", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "validationQuery", "validation-query", String.class, parserContext);
        this.fillBuilderWithAttributeIfExists(builder, element, "validationQueryTimeout", "validation-query-timeout", Integer.TYPE, parserContext);
        builder.setDestroyMethodName("close");
        return builder.getBeanDefinition();
    }

    protected void fillBuilderWithAttributeIfExists(BeanDefinitionBuilder builder, Element parentElement, String propertyName, String elementName, Class<?> expectedType, ParserContext parserContext) {
        Element element = DomUtils.getChildElementByTagName((Element)parentElement, (String)elementName);
        if (element != null) {
            String value = element.getAttribute("value");
            if (value == null) {
                String msg = "Sub element '" + elementName + "' is missing attribute '" + "value" + "'";
                parserContext.getReaderContext().fatal(msg, (Object)parentElement);
                throw new IllegalStateException(msg);
            }
            builder.addPropertyValue(propertyName, (Object)value);
        }
    }
}

