/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.config;

import fr.xebia.management.ServletContextAwareMBeanServerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jmx.support.WebSphereMBeanServerFactoryBean;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ServletContextAwareMBeanServerDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String MBEAN_SERVER_BEAN_NAME = "mbeanServer";
    private static final String SERVER_ATTRIBUTE = "server";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = MBEAN_SERVER_BEAN_NAME;
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServletContextAwareMBeanServerFactory.class);
        builder.setRole(2);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        String serverBeanName = element.getAttribute(SERVER_ATTRIBUTE);
        if (StringUtils.hasText((String)serverBeanName)) {
            builder.addPropertyReference(SERVER_ATTRIBUTE, serverBeanName);
        } else {
            AbstractBeanDefinition specialServer = ServletContextAwareMBeanServerDefinitionParser.findServerForSpecialEnvironment();
            if (specialServer != null) {
                builder.addPropertyValue(SERVER_ATTRIBUTE, (Object)specialServer);
            }
        }
        return builder.getBeanDefinition();
    }

    static AbstractBeanDefinition findServerForSpecialEnvironment() {
        boolean weblogicPresent = ClassUtils.isPresent((String)"weblogic.management.Helper", (ClassLoader)ServletContextAwareMBeanServerDefinitionParser.class.getClassLoader());
        boolean webspherePresent = ClassUtils.isPresent((String)"com.ibm.websphere.management.AdminServiceFactory", (ClassLoader)ServletContextAwareMBeanServerDefinitionParser.class.getClassLoader());
        if (weblogicPresent) {
            RootBeanDefinition bd = new RootBeanDefinition(JndiObjectFactoryBean.class);
            bd.getPropertyValues().add("jndiName", (Object)"java:comp/env/jmx/runtime");
            return bd;
        }
        if (webspherePresent) {
            return new RootBeanDefinition(WebSphereMBeanServerFactoryBean.class);
        }
        return null;
    }
}

