/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.config;

import fr.xebia.springframework.concurrent.ThreadPoolExecutorFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ThreadPoolExecutorFactoryDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String MBEAN_SERVER_BEAN_NAME = "executor-service";
    private static final String POOL_SIZE_ATTRIBUTE = "pool-size";
    private static final String QUEUE_CAPACITY_ATTRIBUTE = "queue-capacity";
    private static final String KEEP_ALIVE_ATTRIBUTE = "keep-alive";
    private static final String REJECTION_POLICY_ATTRIBUTE = "rejection-policy";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = MBEAN_SERVER_BEAN_NAME;
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Class rejectedExecutionHandlerClass;
        String rejectionPolicy;
        String keepAlive;
        String queueCapacity;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ThreadPoolExecutorFactory.class);
        builder.setRole(0);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        String poolSize = element.getAttribute(POOL_SIZE_ATTRIBUTE);
        if (StringUtils.hasText((String)poolSize)) {
            builder.addPropertyValue("poolSize", (Object)poolSize);
        }
        if (StringUtils.hasText((String)(queueCapacity = element.getAttribute(QUEUE_CAPACITY_ATTRIBUTE)))) {
            builder.addPropertyValue("queueCapacity", (Object)queueCapacity);
        }
        if (StringUtils.hasText((String)(keepAlive = element.getAttribute(KEEP_ALIVE_ATTRIBUTE)))) {
            builder.addPropertyValue("keepAliveTimeInSeconds", (Object)keepAlive);
        }
        if ("ABORT".equals(rejectionPolicy = element.getAttribute(REJECTION_POLICY_ATTRIBUTE))) {
            rejectedExecutionHandlerClass = ThreadPoolExecutor.AbortPolicy.class;
        } else if ("CALLER_RUNS".equals(rejectionPolicy)) {
            rejectedExecutionHandlerClass = ThreadPoolExecutor.CallerRunsPolicy.class;
        } else if ("DISCARD".equals(rejectionPolicy)) {
            rejectedExecutionHandlerClass = ThreadPoolExecutor.DiscardPolicy.class;
        } else if ("DISCARD_OLDEST".equals(rejectionPolicy)) {
            rejectedExecutionHandlerClass = ThreadPoolExecutor.DiscardOldestPolicy.class;
        } else {
            throw new IllegalArgumentException("Unsupported 'rejection-policy': '" + rejectionPolicy + "'");
        }
        builder.addPropertyValue("rejectedExecutionHandlerClass", rejectedExecutionHandlerClass);
        return builder.getBeanDefinition();
    }
}

