/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms;

import fr.xebia.jms.wrapper.ConnectionWrapper;
import fr.xebia.management.jms.ManagedConnectionFactory;
import fr.xebia.management.jms.ManagedSession;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.jmx.JmxException;

public class ManagedConnection
extends ConnectionWrapper {
    private final ManagedConnectionFactory.Statistics statistics;

    public ManagedConnection(Connection delegate, ManagedConnectionFactory.Statistics statistics) {
        super(delegate);
        this.statistics = statistics;
    }

    @Override
    public void close() throws JMSException {
        try {
            super.close();
        }
        finally {
            this.statistics.incrementCloseConnectionCount();
        }
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            ManagedSession managedSession = new ManagedSession(super.createSession(transacted, acknowledgeMode), this.statistics);
            return managedSession;
        }
        catch (JmxException e) {
            this.statistics.incrementCreateSessionExceptionCount();
            throw e;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateSessionExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateSessionCount();
        }
    }
}

