/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms;

import fr.xebia.management.jms.ManagedConnection;
import fr.xebia.management.jms.ManagedConnectionFactoryMBean;
import fr.xebia.management.jms.leak.LeakDetectorConnectionFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class ManagedConnectionFactory
implements ConnectionFactory,
ManagedConnectionFactoryMBean {
    private ConnectionFactory connectionFactory;
    private final Statistics statistics = new Statistics();
    private boolean trackLeaks = false;

    public ManagedConnectionFactory() {
    }

    public ManagedConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        try {
            ManagedConnection managedConnection = new ManagedConnection(this.connectionFactory.createConnection(), this.statistics);
            return managedConnection;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateConnectionExceptionCount();
            throw e;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateConnectionExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateConnectionCount();
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        try {
            ManagedConnection managedConnection = new ManagedConnection(this.connectionFactory.createConnection(userName, password), this.statistics);
            return managedConnection;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateConnectionExceptionCount();
            throw e;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateConnectionExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateConnectionCount();
        }
    }

    @Override
    public int getActiveConnectionCount() {
        return this.getCreateConnectionCount() - this.getCloseConnectionCount();
    }

    @Override
    public int getActiveMessageConsumerCount() {
        return this.getCreateMessageConsumerCount() - this.getCloseMessageConsumerCount();
    }

    @Override
    public int getActiveMessageProducerCount() {
        return this.getCreateMessageProducerCount() - this.getCloseMessageProducerCount();
    }

    @Override
    public int getActiveSessionCount() {
        return this.getCreateSessionCount() - this.getCloseSessionCount();
    }

    @Override
    public int getCloseConnectionCount() {
        return this.statistics.getCloseConnectionCount();
    }

    @Override
    public int getCloseMessageConsumerCount() {
        return this.statistics.getCloseMessageConsumerCount();
    }

    @Override
    public int getCloseMessageProducerCount() {
        return this.statistics.getCloseMessageProducerCount();
    }

    @Override
    public int getCloseSessionCount() {
        return this.statistics.getCloseSessionCount();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public int getCreateConnectionCount() {
        return this.statistics.getCreateConnectionCount();
    }

    @Override
    public int getCreateConnectionExceptionCount() {
        return this.statistics.getCreateConnectionExceptionCount();
    }

    @Override
    public int getCreateMessageConsumerCount() {
        return this.statistics.getCreateMessageConsumerCount();
    }

    @Override
    public int getCreateMessageConsumerExceptionCount() {
        return this.statistics.getCreateMessageConsumerExceptionCount();
    }

    @Override
    public int getCreateMessageProducerCount() {
        return this.statistics.getCreateMessageProducerCount();
    }

    @Override
    public int getCreateMessageProducerExceptionCount() {
        return this.statistics.getCreateMessageProducerExceptionCount();
    }

    @Override
    public int getCreateSessionCount() {
        return this.statistics.getCreateSessionCount();
    }

    @Override
    public int getCreateSessionExceptionCount() {
        return this.statistics.getCreateSessionExceptionCount();
    }

    @Override
    public int getReceiveMessageCount() {
        return this.statistics.getReceiveMessageCount();
    }

    @Override
    public long getReceiveMessageDurationInMillis() {
        return this.statistics.getReceiveMessageDurationInMillis();
    }

    @Override
    public int getReceiveMessageExceptionCount() {
        return this.statistics.getReceiveMessageExceptionCount();
    }

    @Override
    public int getSendMessageCount() {
        return this.statistics.getSendMessageCount();
    }

    @Override
    public long getSendMessageDurationInMillis() {
        return this.statistics.getSendMessageDurationInMillis();
    }

    @Override
    public int getSendMessageExceptionCount() {
        return this.statistics.getSendMessageExceptionCount();
    }

    @Override
    public boolean isTrackLeaks() {
        return this.trackLeaks;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        if (this.trackLeaks && !(connectionFactory instanceof LeakDetectorConnectionFactory)) {
            connectionFactory = new LeakDetectorConnectionFactory(connectionFactory);
        }
        this.connectionFactory = connectionFactory;
    }

    @Deprecated
    public void setDelegate(ConnectionFactory delegate) {
        this.connectionFactory = delegate;
    }

    public void setTrackLeaks(boolean trackLeaks) {
        this.trackLeaks = trackLeaks;
        if (trackLeaks && this.connectionFactory != null && !(this.connectionFactory instanceof LeakDetectorConnectionFactory)) {
            this.connectionFactory = new LeakDetectorConnectionFactory(this.connectionFactory);
        }
    }

    @Override
    public List<String> dumpAllOpenedResources() {
        if (this.connectionFactory instanceof LeakDetectorConnectionFactory) {
            return ((LeakDetectorConnectionFactory)this.connectionFactory).dumpAllOpenedResources();
        }
        return Collections.emptyList();
    }

    public static class Statistics {
        private final AtomicInteger closeConnectionCount = new AtomicInteger();
        private final AtomicInteger closeMessageConsumerCount = new AtomicInteger();
        private final AtomicInteger closeMessageProducerCount = new AtomicInteger();
        private final AtomicInteger closeSessionCount = new AtomicInteger();
        private final AtomicInteger createConnectionCount = new AtomicInteger();
        private final AtomicInteger createConnectionExceptionCount = new AtomicInteger();
        private final AtomicInteger createMessageConsumerCount = new AtomicInteger();
        private final AtomicInteger createMessageConsumerExceptionCount = new AtomicInteger();
        private final AtomicInteger createMessageProducerCount = new AtomicInteger();
        private final AtomicInteger createMessageProducerExceptionCount = new AtomicInteger();
        private final AtomicInteger createSessionCount = new AtomicInteger();
        private final AtomicInteger createSessionExceptionCount = new AtomicInteger();
        private final AtomicInteger receiveMessageCount = new AtomicInteger();
        private final AtomicLong receiveMessageDurationInMillis = new AtomicLong();
        private final AtomicInteger receiveMessageExceptionCount = new AtomicInteger();
        private final AtomicInteger sendMessageCount = new AtomicInteger();
        private final AtomicLong sendMessageDurationInMillis = new AtomicLong();
        private final AtomicInteger sendMessageExceptionCount = new AtomicInteger();

        public int getCloseConnectionCount() {
            return this.closeConnectionCount.get();
        }

        public int getCloseMessageConsumerCount() {
            return this.closeMessageConsumerCount.get();
        }

        public int getCloseMessageProducerCount() {
            return this.closeMessageProducerCount.get();
        }

        public int getCloseSessionCount() {
            return this.closeSessionCount.get();
        }

        public int getCreateConnectionCount() {
            return this.createConnectionCount.get();
        }

        public int getCreateConnectionExceptionCount() {
            return this.createConnectionExceptionCount.get();
        }

        public int getCreateMessageConsumerCount() {
            return this.createMessageConsumerCount.get();
        }

        public int getCreateMessageConsumerExceptionCount() {
            return this.createMessageConsumerExceptionCount.get();
        }

        public int getCreateMessageProducerCount() {
            return this.createMessageProducerCount.get();
        }

        public int getCreateMessageProducerExceptionCount() {
            return this.createMessageProducerExceptionCount.get();
        }

        public int getCreateSessionCount() {
            return this.createSessionCount.get();
        }

        public int getCreateSessionExceptionCount() {
            return this.createSessionExceptionCount.get();
        }

        public int getReceiveMessageCount() {
            return this.receiveMessageCount.get();
        }

        public long getReceiveMessageDurationInMillis() {
            return this.receiveMessageDurationInMillis.get();
        }

        public int getReceiveMessageExceptionCount() {
            return this.receiveMessageExceptionCount.get();
        }

        public int getSendMessageCount() {
            return this.sendMessageCount.get();
        }

        public long getSendMessageDurationInMillis() {
            return this.sendMessageDurationInMillis.get();
        }

        public int getSendMessageExceptionCount() {
            return this.sendMessageExceptionCount.get();
        }

        public void incrementCloseConnectionCount() {
            this.closeConnectionCount.incrementAndGet();
        }

        public void incrementCloseMessageConsumerCount() {
            this.closeMessageConsumerCount.incrementAndGet();
        }

        public void incrementCloseMessageProducerCount() {
            this.closeMessageProducerCount.incrementAndGet();
        }

        public void incrementCloseSessionCount() {
            this.closeSessionCount.incrementAndGet();
        }

        public void incrementCreateConnectionCount() {
            this.createConnectionCount.incrementAndGet();
        }

        public void incrementCreateConnectionExceptionCount() {
            this.createConnectionExceptionCount.incrementAndGet();
        }

        public void incrementCreateMessageConsumerCount() {
            this.createMessageConsumerCount.incrementAndGet();
        }

        public void incrementCreateMessageConsumerExceptionCount() {
            this.createMessageConsumerExceptionCount.incrementAndGet();
        }

        public void incrementCreateMessageProducerCount() {
            this.createMessageProducerCount.incrementAndGet();
        }

        public void incrementCreateMessageProducerExceptionCount() {
            this.createMessageProducerExceptionCount.incrementAndGet();
        }

        public void incrementCreateSessionCount() {
            this.createSessionCount.incrementAndGet();
        }

        public void incrementCreateSessionExceptionCount() {
            this.createSessionExceptionCount.incrementAndGet();
        }

        public void incrementReceivedMessageCount() {
            this.receiveMessageCount.incrementAndGet();
        }

        public void incrementReceivedMessageExceptionCount() {
            this.receiveMessageExceptionCount.incrementAndGet();
        }

        public void incrementReceiveMessageDurationInMillis(long delta) {
            this.receiveMessageDurationInMillis.addAndGet(delta);
        }

        public void incrementSendMessageCount() {
            this.sendMessageCount.incrementAndGet();
        }

        public void incrementSendMessageDurationInMillis(long delta) {
            this.sendMessageDurationInMillis.addAndGet(delta);
        }

        public void incrementSendMessageExceptionCount() {
            this.sendMessageExceptionCount.incrementAndGet();
        }
    }
}

