/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms;

import fr.xebia.jms.wrapper.MessageConsumerWrapper;
import fr.xebia.management.jms.ManagedConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;

public class ManagedMessageConsumer
extends MessageConsumerWrapper {
    private final ManagedConnectionFactory.Statistics statistics;

    public ManagedMessageConsumer(MessageConsumer delegate, ManagedConnectionFactory.Statistics statistics) {
        super(delegate);
        this.statistics = statistics;
    }

    @Override
    public void close() throws JMSException {
        try {
            super.close();
        }
        finally {
            this.statistics.incrementCloseMessageConsumerCount();
        }
    }

    @Override
    public Message receive() throws JMSException {
        long timeBefore = System.currentTimeMillis();
        Message message = null;
        try {
            try {
                message = super.receive();
            }
            catch (JMSException e) {
                this.statistics.incrementReceivedMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementReceivedMessageExceptionCount();
                throw e;
            }
        }
        finally {
            if (message != null) {
                this.statistics.incrementReceivedMessageCount();
            }
            this.statistics.incrementReceiveMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
        return message;
    }

    @Override
    public Message receive(long timeout) throws JMSException {
        long timeBefore = System.currentTimeMillis();
        Message message = null;
        try {
            try {
                message = super.receive(timeout);
            }
            catch (JMSException e) {
                this.statistics.incrementReceivedMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementReceivedMessageExceptionCount();
                throw e;
            }
        }
        finally {
            if (message != null) {
                this.statistics.incrementReceivedMessageCount();
            }
            this.statistics.incrementReceiveMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
        return message;
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        long timeBefore = System.currentTimeMillis();
        Message message = null;
        try {
            try {
                message = super.receiveNoWait();
            }
            catch (JMSException e) {
                this.statistics.incrementReceivedMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementReceivedMessageExceptionCount();
                throw e;
            }
        }
        finally {
            if (message != null) {
                this.statistics.incrementReceivedMessageCount();
            }
            this.statistics.incrementReceiveMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
        return message;
    }
}

