/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms;

import fr.xebia.jms.wrapper.MessageProducerWrapper;
import fr.xebia.management.jms.ManagedConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class ManagedMessageProducer
extends MessageProducerWrapper {
    private final ManagedConnectionFactory.Statistics statistics;

    public ManagedMessageProducer(MessageProducer delegate, ManagedConnectionFactory.Statistics statistics) {
        super(delegate);
        this.statistics = statistics;
    }

    @Override
    public void close() throws JMSException {
        try {
            super.close();
        }
        finally {
            this.statistics.incrementCloseMessageProducerCount();
        }
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        long timeBefore = System.currentTimeMillis();
        try {
            try {
                super.send(destination, message);
            }
            catch (JMSException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
        }
        finally {
            this.statistics.incrementSendMessageCount();
            this.statistics.incrementSendMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long timeBefore = System.currentTimeMillis();
        try {
            try {
                super.send(destination, message, deliveryMode, priority, timeToLive);
            }
            catch (JMSException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
        }
        finally {
            this.statistics.incrementSendMessageCount();
            this.statistics.incrementSendMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
    }

    @Override
    public void send(Message message) throws JMSException {
        long timeBefore = System.currentTimeMillis();
        try {
            try {
                super.send(message);
            }
            catch (JMSException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
        }
        finally {
            this.statistics.incrementSendMessageCount();
            this.statistics.incrementSendMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long timeBefore = System.currentTimeMillis();
        try {
            try {
                super.send(message, deliveryMode, priority, timeToLive);
            }
            catch (JMSException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
            catch (RuntimeException e) {
                this.statistics.incrementSendMessageExceptionCount();
                throw e;
            }
        }
        finally {
            this.statistics.incrementSendMessageCount();
            this.statistics.incrementSendMessageDurationInMillis(System.currentTimeMillis() - timeBefore);
        }
    }
}

