/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms;

import fr.xebia.jms.wrapper.SessionWrapper;
import fr.xebia.management.jms.ManagedConnectionFactory;
import fr.xebia.management.jms.ManagedMessageConsumer;
import fr.xebia.management.jms.ManagedMessageProducer;
import fr.xebia.management.jms.ManagedTopicSubscriber;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class ManagedSession
extends SessionWrapper {
    private final ManagedConnectionFactory.Statistics statistics;

    public ManagedSession(Session delegate, ManagedConnectionFactory.Statistics statistics) {
        super(delegate);
        this.statistics = statistics;
    }

    @Override
    public void close() throws JMSException {
        try {
            super.close();
        }
        finally {
            this.statistics.incrementCloseSessionCount();
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        try {
            TopicSubscriber topicSubscriber = this.decorate(super.createDurableSubscriber(topic, name));
            return topicSubscriber;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateMessageConsumerCount();
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        try {
            TopicSubscriber topicSubscriber = this.decorate(super.createDurableSubscriber(topic, name, messageSelector, noLocal));
            return topicSubscriber;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateMessageConsumerCount();
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        try {
            MessageConsumer messageConsumer = this.decorate(super.createConsumer(destination));
            return messageConsumer;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateMessageConsumerCount();
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        try {
            MessageConsumer messageConsumer = this.decorate(super.createConsumer(destination, messageSelector));
            return messageConsumer;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateMessageConsumerCount();
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        try {
            MessageConsumer messageConsumer = this.decorate(super.createConsumer(destination, messageSelector, noLocal));
            return messageConsumer;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateMessageConsumerExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateMessageConsumerCount();
        }
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        try {
            MessageProducer messageProducer = this.decorate(super.createProducer(destination));
            return messageProducer;
        }
        catch (JMSException e) {
            this.statistics.incrementCreateMessageProducerExceptionCount();
            throw e;
        }
        catch (RuntimeException e) {
            this.statistics.incrementCreateMessageProducerExceptionCount();
            throw e;
        }
        finally {
            this.statistics.incrementCreateMessageProducerCount();
        }
    }

    protected MessageConsumer decorate(MessageConsumer messageConsumer) {
        return new ManagedMessageConsumer(messageConsumer, this.statistics);
    }

    protected TopicSubscriber decorate(TopicSubscriber topicSubscriber) {
        return new ManagedTopicSubscriber(topicSubscriber, this.statistics);
    }

    protected MessageProducer decorate(MessageProducer messageProducer) {
        return new ManagedMessageProducer(messageProducer, this.statistics);
    }
}

