/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms.leak;

import fr.xebia.jms.wrapper.ConnectionWrapper;
import fr.xebia.management.jms.leak.CreationContext;
import fr.xebia.management.jms.leak.LeakDetectorConnectionFactory;
import fr.xebia.management.jms.leak.LeakDetectorSession;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakDetectorConnection
extends ConnectionWrapper
implements Connection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CreationContext creationContext = new CreationContext();
    private final LeakDetectorConnectionFactory connectionFactory;
    private final Set<LeakDetectorSession> openSessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public LeakDetectorConnection(Connection delegate, LeakDetectorConnectionFactory connectionFactory) {
        super(delegate);
        this.connectionFactory = connectionFactory;
        connectionFactory.registerOpenConnection(this);
    }

    @Override
    public void close() throws JMSException {
        if (!this.openSessions.isEmpty()) {
            this.logger.warn("connection.close() is called on {} before closing {} sessions:", (Object)this, (Object)this.openSessions.size());
            for (LeakDetectorSession session : this.openSessions) {
                this.logger.warn(session.dumpCreationContext("   "));
            }
        }
        super.close();
        this.connectionFactory.unregisterOpenConnection(this);
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new LeakDetectorSession(super.createSession(transacted, acknowledgeMode), this);
    }

    public Set<LeakDetectorSession> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    public void registerOpenSession(LeakDetectorSession session) {
        this.openSessions.add(session);
    }

    public void unregisterOpenSession(LeakDetectorSession session) {
        this.openSessions.remove(session);
    }

    public String dumpCreationContext(String offest) {
        return String.valueOf(offest) + this.delegate().toString() + " - " + this.creationContext.dumpContext(offest);
    }
}

