/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms.leak;

import fr.xebia.jms.wrapper.ConnectionFactoryWrapper;
import fr.xebia.management.jms.leak.LeakDetectorConnection;
import fr.xebia.management.jms.leak.LeakDetectorMessageConsumer;
import fr.xebia.management.jms.leak.LeakDetectorMessageProducer;
import fr.xebia.management.jms.leak.LeakDetectorSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class LeakDetectorConnectionFactory
extends ConnectionFactoryWrapper
implements ConnectionFactory {
    private final Set<LeakDetectorConnection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public LeakDetectorConnectionFactory(ConnectionFactory delegate) {
        super(delegate);
    }

    @Override
    public Connection createConnection() throws JMSException {
        return new LeakDetectorConnection(super.createConnection(), this);
    }

    @Override
    public Connection createConnection(String userName, String password) throws JMSException {
        return new LeakDetectorConnection(super.createConnection(userName, password), this);
    }

    public void registerOpenConnection(LeakDetectorConnection connection) {
        this.openConnections.add(connection);
    }

    public void unregisterOpenConnection(LeakDetectorConnection connection) {
        this.openConnections.remove(connection);
    }

    public Set<LeakDetectorConnection> getOpenConnections() {
        return Collections.unmodifiableSet(this.openConnections);
    }

    public List<String> dumpAllOpenedResources() {
        ArrayList<String> dumps = new ArrayList<String>();
        for (LeakDetectorConnection connection : this.openConnections) {
            dumps.add(connection.dumpCreationContext(""));
            for (LeakDetectorSession session : connection.getOpenSessions()) {
                dumps.add(session.dumpCreationContext("   "));
                for (LeakDetectorMessageProducer producer : session.getOpenMessageProducers()) {
                    dumps.add(producer.dumpCreationContext("      "));
                }
                for (LeakDetectorMessageConsumer consumer : session.getOpenMessageConsumers()) {
                    dumps.add(consumer.dumpCreationContext("      "));
                }
            }
        }
        return dumps;
    }
}

