/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms.leak;

import fr.xebia.jms.wrapper.MessageProducerWrapper;
import fr.xebia.management.jms.leak.CreationContext;
import fr.xebia.management.jms.leak.LeakDetectorSession;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public class LeakDetectorMessageProducer
extends MessageProducerWrapper
implements MessageProducer {
    private final CreationContext creationContext = new CreationContext();
    private final LeakDetectorSession leakDetectorSession;

    public LeakDetectorMessageProducer(MessageProducer delegate, LeakDetectorSession leakDetectorSession) {
        super(delegate);
        this.leakDetectorSession = leakDetectorSession;
        leakDetectorSession.registerOpenMessageProducer(this);
    }

    @Override
    public void close() throws JMSException {
        super.close();
        this.leakDetectorSession.unregisterOpenMessageProducer(this);
    }

    public CreationContext getCreationContext() {
        return this.creationContext;
    }

    public LeakDetectorSession getLeakDetectorSession() {
        return this.leakDetectorSession;
    }

    public String dumpCreationContext(String offest) {
        return String.valueOf(offest) + this.delegate().toString() + " - " + this.creationContext.dumpContext(offest);
    }
}

