/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.jms.leak;

import fr.xebia.jms.wrapper.SessionWrapper;
import fr.xebia.management.jms.leak.CreationContext;
import fr.xebia.management.jms.leak.LeakDetectorConnection;
import fr.xebia.management.jms.leak.LeakDetectorMessageConsumer;
import fr.xebia.management.jms.leak.LeakDetectorMessageProducer;
import fr.xebia.management.jms.leak.LeakDetectorTopicSubscriber;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakDetectorSession
extends SessionWrapper
implements Session {
    private final CreationContext creationContext = new CreationContext();
    private final LeakDetectorConnection leakDetectorConnection;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<LeakDetectorMessageConsumer> openMessageConsumers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<LeakDetectorMessageProducer> openMessageProducers = Collections.newSetFromMap(new ConcurrentHashMap());

    public LeakDetectorSession(Session delegate, LeakDetectorConnection leakDetectorConnection) {
        super(delegate);
        this.leakDetectorConnection = leakDetectorConnection;
        leakDetectorConnection.registerOpenSession(this);
    }

    @Override
    public void close() throws JMSException {
        if (!this.openMessageConsumers.isEmpty()) {
            this.logger.warn("session.close() is called on {} before closing {} message consumers:", (Object)this, (Object)this.openMessageConsumers.size());
            for (LeakDetectorMessageConsumer messageConsumer : this.openMessageConsumers) {
                this.logger.warn(messageConsumer.dumpCreationContext("   "));
            }
        }
        if (!this.openMessageProducers.isEmpty()) {
            this.logger.warn("session.close() is called on {} before closing {} message producers:", (Object)this, (Object)this.openMessageProducers.size());
            for (LeakDetectorMessageProducer messageProducer : this.openMessageProducers) {
                this.logger.warn(messageProducer.dumpCreationContext("   "));
            }
        }
        super.close();
        this.leakDetectorConnection.unregisterOpenSession(this);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new LeakDetectorMessageConsumer(super.createConsumer(destination), this);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new LeakDetectorMessageConsumer(super.createConsumer(destination, messageSelector), this);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new LeakDetectorMessageConsumer(super.createConsumer(destination, messageSelector, noLocal), this);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return new LeakDetectorTopicSubscriber(super.createDurableSubscriber(topic, name), this);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return new LeakDetectorTopicSubscriber(super.createDurableSubscriber(topic, name, messageSelector, noLocal), this);
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new LeakDetectorMessageProducer(super.createProducer(destination), this);
    }

    public String dumpCreationContext(String offest) {
        return String.valueOf(offest) + this.delegate().toString() + " - " + this.creationContext.dumpContext(offest);
    }

    public Set<LeakDetectorMessageConsumer> getOpenMessageConsumers() {
        return Collections.unmodifiableSet(this.openMessageConsumers);
    }

    public Set<LeakDetectorMessageProducer> getOpenMessageProducers() {
        return Collections.unmodifiableSet(this.openMessageProducers);
    }

    public void registerOpenMessageConsumer(LeakDetectorMessageConsumer messageConsumer) {
        this.openMessageConsumers.add(messageConsumer);
    }

    public void registerOpenMessageProducer(LeakDetectorMessageProducer messageProducer) {
        this.openMessageProducers.add(messageProducer);
    }

    public void unregisterOpenMessageConsumer(LeakDetectorMessageConsumer messageConsumer) {
        this.openMessageConsumers.remove(messageConsumer);
    }

    public void unregisterOpenMessageProducer(LeakDetectorMessageProducer messageProducer) {
        this.openMessageProducers.remove(messageProducer);
    }
}

