/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.management.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

@ManagedResource
public class WebApplicationMavenInformation
implements ServletContextAware,
InitializingBean,
SelfNaming,
BeanNameAware {
    private static final String POM_PROPERTY_ARTIFACT_ID = "artifactId";
    private static final String POM_PROPERTY_GROUP_ID = "groupId";
    private static final String POM_PROPERTY_VERSION = "version";
    private String artifactId = "#UNKNOWN#";
    private String beanName;
    private String groupId = "#UNKNOWN#";
    private String jmxDomain = "fr.xebia";
    protected final Logger logger = LoggerFactory.getLogger(WebApplicationMavenInformation.class);
    private ObjectName objectName;
    private ServletContext servletContext;
    private String version = "#UNKNOWN#";

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.servletContext, (String)"'servletConfig' can not be null");
        this.loadInformationFromPomProperties();
    }

    @ManagedAttribute(description="Maven ${project.artifactId} property extracted from ${webapp-home}/META-INF/${groupId}/${artifactId}/pom.properties file")
    public String getArtifactId() {
        return this.artifactId;
    }

    @ManagedAttribute(description="Maven ${project.groupId}:${project.artifactId}:${project.version} properties extracted from ${webapp-home}/META-INF/${groupId}/${artifactId}/pom.properties file")
    public String getFullyQualifiedArtifactIdentifier() {
        return String.valueOf(this.groupId) + ":" + this.artifactId + ":" + this.version;
    }

    @ManagedAttribute(description="Maven ${project.groupId} property extracted from ${webapp-home}/META-INF/${groupId}/${artifactId}/pom.properties file")
    public String getGroupId() {
        return this.groupId;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            String objectNameString = String.valueOf(this.jmxDomain) + ":type=WebApplicationMavenInformation";
            if (StringUtils.hasText((String)this.beanName)) {
                objectNameString = String.valueOf(objectNameString) + ",name=" + ObjectName.quote(this.beanName);
            }
            this.objectName = ObjectName.getInstance(objectNameString);
        }
        return this.objectName;
    }

    @ManagedAttribute(description="Maven ${project.version} property extracted from ${webapp-home}/META-INF/${groupId}/${artifactId}/pom.properties file")
    public String getVersion() {
        return this.version;
    }

    private void loadInformationFromPomProperties() throws URISyntaxException, IOException {
        String mavenMetaInfFolderPath = this.servletContext.getRealPath("/META-INF/maven/");
        if (mavenMetaInfFolderPath == null) {
            this.logger.warn("Folder " + this.servletContext.getRealPath("/") + "/META-INF/maven/" + " not found. Application probably in development mode, could not determine application maven information");
            return;
        }
        File mavenMetaInfFolder = new File(mavenMetaInfFolderPath);
        if (!mavenMetaInfFolder.exists()) {
            this.logger.warn("Folder " + mavenMetaInfFolder.getAbsolutePath() + " not found. Application probably in development mode, could not determine application maven information");
            return;
        }
        File[] groupIdFolderAsArray = mavenMetaInfFolder.listFiles(new DirectoryFileFilter());
        if (groupIdFolderAsArray.length == 0) {
            this.logger.warn("Folder /META-INF/maven/${project.groupId} not found under " + mavenMetaInfFolder.getAbsolutePath() + ". Application probably in development mode, could not determine application maven information");
            return;
        }
        if (groupIdFolderAsArray.length > 1) {
            this.logger.warn("More than one folder found under " + mavenMetaInfFolder.getAbsolutePath() + " : " + Arrays.asList(groupIdFolderAsArray) + ". Could not determine application maven information");
            return;
        }
        File groupIdFolder = groupIdFolderAsArray[0];
        File[] artifactIdFolderAsArray = groupIdFolder.listFiles(new DirectoryFileFilter());
        if (artifactIdFolderAsArray.length == 0) {
            this.logger.warn("Folder /META-INF/maven/" + groupIdFolder.getName() + "/${project.artifactId} not found under " + mavenMetaInfFolder.getAbsolutePath() + ". Application probably in development mode, could not determine application maven information");
            return;
        }
        if (artifactIdFolderAsArray.length > 1) {
            this.logger.warn("More than one folder found under " + groupIdFolder.getAbsolutePath() + " : " + Arrays.asList(artifactIdFolderAsArray) + ". Could not determine application maven information");
            return;
        }
        File artifactIdFolder = artifactIdFolderAsArray[0];
        File pomPropertiesFile = new File(artifactIdFolder, "pom.properties");
        if (!pomPropertiesFile.exists()) {
            this.logger.warn("File " + pomPropertiesFile.getAbsolutePath() + " not found. Application probably in development mode, could not determine application maven information");
            return;
        }
        Properties pomProperties = new Properties();
        FileInputStream in = new FileInputStream(pomPropertiesFile);
        try {
            pomProperties.load(in);
        }
        finally {
            in.close();
        }
        this.groupId = pomProperties.getProperty(POM_PROPERTY_GROUP_ID, this.groupId);
        this.artifactId = pomProperties.getProperty(POM_PROPERTY_ARTIFACT_ID, this.artifactId);
        this.version = pomProperties.getProperty(POM_PROPERTY_VERSION, this.version);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void setObjectName(String objectName) throws MalformedObjectNameException {
        this.objectName = objectName == null ? null : ObjectName.getInstance(objectName);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private static class DirectoryFileFilter
    implements FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

